﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief  任意の UI 要素を配置する UI 要素です。
//---------------------------------------------------------------------------
class Canvas : public UIElement
{
private:
    typedef UIElement Base;

public:
    Canvas();

protected:
    /*override*/ const nw::math::Vector2 OnMeasure(UIRenderer& renderer) const;

    /*override*/ bool CanAlignHorizontal(const UIElement& element) const { (void)element; return false; }
    /*override*/ bool CanAlignVertical(const UIElement& element) const { (void)element; return false; }

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "Canvas";
    }
#endif
};

} // dw
} // internal
} // nw
