﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_FileBrowser.h>

#if defined(NW_PLATFORM_CAFE)
#include <cafe/fs.h>
#endif

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief  ディレクトリ、ファイルの一覧を表示する UI 要素です。
//---------------------------------------------------------------------------
class FileBrowserCafe : public FileBrowser
{
private:
    typedef FileBrowser Base;

public:
    FileBrowserCafe();

public:
#if defined(NW_PLATFORM_CAFE)
    void Initialize(FSClient* fsClient, FSCmdBlock* fsCmdBlock);
#endif
    void Finalize();

protected:
    /* override */ bool CanMoveParentDirectory(const char* pPath) ;
    /* override */ bool BuildFileEntries(const char* pPath);

private:
#if defined(NW_PLATFORM_CAFE)
    FSClient* m_FsClient;
    FSCmdBlock* m_FsCmdBlock;
    FSStatus m_LastError;
#endif

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "FileBrowserCafe";
    }
#endif
};

} // dw
} // internal
} // nw
