﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEV_RESOURCE_H_
#define NW_DEV_RESOURCE_H_

#include <nw/config.h>
#include <nw/ut/ut_Memory.h>

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#include <gl/glew.h>
#include <nw/gfnd/gl/gfnd_TextureGL.h>
#else
#include <cafe/gx2.h>
#include <nw/gfnd/cafe/gfnd_TextureCafeGX2.h>
#endif

namespace nw
{
namespace dev
{

static const int POINTER_TEXTURE_SIZE = 32;                                                     //!< ポインタテクスチャの大きさです。
static const int POINTER_TEXTURE_DATA_SIZE = POINTER_TEXTURE_SIZE * POINTER_TEXTURE_SIZE * 4;   //!< ポインタテクスチャのデータサイズです。

//! @brief ポインタアイコンのタイプを表す列挙子です。
enum PointerType
{
    POINTER_ARROW,
    POINTER_MOVE,
    POINTER_RESIZE
};

//! @brief ポインタテクスチャに関するデータを格納する構造体です。
struct PointerData
{
    const u8* data; //!< ポインタテクスチャデータです。
    u16 width;      //!< ポインタテクスチャの幅です。
    u16 height;     //!< ポインタテクスチャの高さです。
    u16 centerX;    //!< ポインタテクスチャの中心 x 座標です。
    u16 centerY;    //!< ポインタテクスチャの中心 y 座標です。
};

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
//---------------------------------------------------------------------------
//! @brief        ポインタアイコンのテクスチャを生成します。
//!
//! @param[in]    allocator  アロケーターです。
//! @param[in]    type       ポインタアイコンのタイプです。
//! @param[in]    texture    テクスチャ情報です。
//!
//! @return       画像データへのポインタを返します。
//---------------------------------------------------------------------------
u8* CreatePointerTexture( nw::ut::IAllocator* allocator, PointerType type, nw::gfnd::TextureGL* texture );
#else
//---------------------------------------------------------------------------
//! @brief        ポインタアイコンのテクスチャを生成します。
//!
//! @param[in]    allocator  アロケーターです。
//! @param[in]    type       ポインタアイコンのタイプです。
//! @param[in]    texture    テクスチャ情報です。
//! @param[in]    textureGX2 GX2Texture へのポインタです。
//!
//! @return       画像データへのポインタを返します。
//---------------------------------------------------------------------------
u8* CreatePointerTexture( nw::ut::IAllocator* allocator, PointerType type, nw::gfnd::TextureCafeGX2* texture, GX2Texture* textureGX2 );
#endif

//---------------------------------------------------------------------------
//! @brief        ポインタテクスチャのデータを取得します。
//!
//! @param[in]    type      取得するポインタテクスチャのタイプです。
//!
//! @return       テクスチャデータへのポインタを返します。
//---------------------------------------------------------------------------
const PointerData* GetPointerData(PointerType type);

} // namespace dev
} // namespace nw

#endif // NW_DEV_RESOURCE_H_
