﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DEV_H_
#define NW_DEV_H_

/*!
  @namespace  nw::dev
  @brief      開発用ライブラリの名前空間です。
  @details
    開発用ライブラリですのでNW_DEV_DISABLEDを定義して製品には含めないようにしてください。

    dev ライブラリの関数の一部は、内部で Cafe SDK のデバッグパッドライブラリの関数を使用しており
    Release 版では dev ライブラリのパッド関連の関数は空定義に置き換わります。
*/

#include <nw/dev/dev_Config.h>
#include <nw/dev/dev_Fs.h>
#include <nw/dev/dev_Profile.h>
#include <nw/dev/dev_Utility.h>
#include <nw/dev/dev_Memory.h>
#include <nw/dev/dev_PrimitiveRenderer.h>
#include <nw/dev/dev_Pad.h>
#include <nw/dev/dev_PadProcessor.h>
#include <nw/dev/dev_Mouse.h>
#include <nw/dev/dev_FileDeviceManager.h>
#include <nw/dev/dev_MeterDrawer.h>
#include <nw/dev/dev_DevTextWriter.h>
#include <nw/dev/dev_Resource.h>
#include <nw/dev/dev_Logger.h>

#if defined(NW_PLATFORM_CAFE)
#include <nw/dev/dev_MapFile.h>
#endif

/* NW_DEV_H_ */
#endif
