﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CTRL_SELECT_BUTTON_H_
#define NW_CTRL_SELECT_BUTTON_H_

#include <nw/ctrl/ctrl_AnimButton.h>

namespace nw
{

namespace ctrl
{

//---------------------------------------------------------------------------
//! @brief ボタンが押されたときにSTATE_DOWN_IDLEのままになりますが、そこからCancelアクションを
//!        発行することでSTATE_OFFに戻ることができるボタンです。
//!
//! @details
//! DecisionButtonと挙動が似ていますが、STATE_DOWN_IDLEの状態でCancelアニメが発行されると、
//! STATE_OFFに戻ることができます。
//!
//! このため、ON/OFFとDOWNの他にもう一つ、DOWN_IDLEからOFF_IDLEに戻るアニメ(Cancelアニメ)が
//! 必要です。Cancelアニメはパラメータアニメの3つ目に指定してください。
//!
//! SelectButtonは、NormalButtonと同様にデフォルトではIsExcludeDownがfalseになっています。
//!
//---------------------------------------------------------------------------
class SelectButton : public AnimButton
{
public:
    //! 実行時型情報です。
    NW_UT_RUNTIME_TYPEINFO(AnimButton);

    //! @brief コンストラクタです。
    //!
    SelectButton() : AnimButton() {}

    //! @brief ボタンの構築を行います。
    //!
    //! AnimButtonの標準の動作に加えて、パラメータアニメの3つ目に指定された
    //! キャンセルアニメを作成します。
    //!
    //! @param[in] controlSrc   コントロールの情報
    //! @param[in,out] layout   所属するレイアウト
    //!
    void Build(const lyt::ControlSrc& controlSrc, lyt::Layout* layout);

    //! @brief 指定した位置にボタンが当たっているか否かを取得します。
    //!
    //! @details
    //! Cancelアニメを再生しているときは当たりが発生しないようにします。
    //!
    virtual bool HitTest(const math::VEC2& vec2) const;

protected:
    //! @brief ボタンの挙動をカスタマイズするためにオーバーライドします。
    //!
    virtual bool ProcessOff();
    virtual bool ProcessCancel();
    virtual void FinishCancel();

};

} // namespace nw::ctrl
} // namespace nw

#endif // NW_CTRL_SELECT_BUTTON_H_
