﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace rid {

    /**
     * @brief    インストールされている全てのコンテンツの破損チェックを行います。
     *           破損していたコンテンツは削除されます。
     *
     * @return   処理の結果が返ります。
     * @retval   ResultNandOrSdCardMaybeCorrupted    破損しているコンテンツの削除に失敗し、NAND または SD カードが破損している可能性があります。
     * @retval   ResultSdCardMaybeCorrupted          破損しているコンテンツの削除に失敗し、SD カードが破損している可能性があります。
     */
    Result CheckContentsIntegrity() NN_NOEXCEPT;

    /**
     * @brief    本体に存在する全ての mii の削除を行います。
     *
     * @return   処理の結果が返ります。
     */
    Result DeleteAllMii() NN_NOEXCEPT;

    /**
     * @brief    本体に存在する全てのアルバムを削除します。
     *
     * @details  SD カードが使用できる状態であるときは SD カードに存在するアルバムも削除します。
     *
     * @return   処理の結果が返ります。
     */
    Result DeleteAllAlbums() NN_NOEXCEPT;
}}
