﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "repair_CryptUtility.h"
#include <nn/nn_Result.h>

namespace nn
{
    namespace repair
    {
        struct BlockHeader
        {
            InitialVector initialVector;
            Cmac cmac;
        };

        class IProtectedFileEncryptor
        {
        public:
            virtual ~IProtectedFileEncryptor() {}
            virtual nn::Result GenerateEncryptedKey(Key128 *pOut) = 0;
            virtual nn::Result LoadKey(Key128 encrpytedKey) = 0;
            virtual nn::Result CreateNewBlock(void * pOut, int64_t index, size_t size) = 0;
            virtual nn::Result DeProcessDataBlock(void * pOut, const BlockHeader &header, int64_t index, const void * buffer, size_t size) = 0;
            virtual nn::Result ProcessDataBlock(BlockHeader *pOutHeader, void * pOut, int64_t index, const void * buffer, size_t size) = 0;
            virtual nn::Result CalculateCmac(Cmac *pOut, void * buffer, size_t size) = 0;
        };

        nn::Result CreateProtectedFileEncryptor(std::shared_ptr<IProtectedFileEncryptor> *pOut, const char* name);
    }
}
