﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <glv.h>
#include <nn/settings/factory/settings_SerialNumber.h>
#include "repair_Types.h"

namespace nn { namespace repair {

    void GetFirmwareVersionLabel(glv::Label* pOutLabel) NN_NOEXCEPT;
    nn::Result GetSerialNumberLabel(glv::Label* pOutLabel) NN_NOEXCEPT;
    void GetTransfererSerialNumberLabel(glv::Label* pOutLabel, const nn::settings::factory::SerialNumber* pSerialNumber) NN_NOEXCEPT;
    nn::Result GetDeviceIdLabel(glv::Label* pOutLabel) NN_NOEXCEPT;
    void GetToolInformationLabel(glv::Label* pOutLabel, const char* toolName, int majorVersion, int minorVersion) NN_NOEXCEPT;
    void GetAirplaneModeLabel(glv::Label* pOutLabel) NN_NOEXCEPT;

}} // namespace nn::repair
