﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkLog.h>
#include <nn/ndd/detail/ndd_Log.h>

//NDD_NDD_LOG()の有効化
//#define NN_NDD_ENABLE_LOG

#ifdef NN_NDD_ENABLE_LOG
#define NN_NDD_LOG(format, ...) NN_DETAIL_NDD_INFO(format, ##__VA_ARGS__)
#else
#define NN_NDD_LOG(...)             static_cast<void>(0)
#endif

namespace nn { namespace ndd {

void PrintByteDataAsHex(const void* pData, uint16_t length);
int64_t GetCurrentTimeMs();

}}
