﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ndd/detail/ndd_InternalTypes.h>

namespace nn { namespace ndd {

//[todo]dataがスタックを消費しないように変更
class Message{
public:
    static const size_t DataSizeMax = 1536;
    void Set(int id);
    void Set(int id, const void* pData, size_t size);
    int GetId() const;
    const uint8_t* GetDataPtr() const;

    //[todo]使用フラグはMessageから分離
    bool m_IsUsing;
private:
    int m_Id;
    uint8_t m_Data[DataSizeMax];
};

enum ApiId{
    //初期化
    ApiId_Initialize                 = 0,
    ApiId_Finalize                   = 1,
    //状態
    ApiId_EnableAutoCommunication    = 10,
    ApiId_DisableAutoCommunication   = 11,
    //送信
    ApiId_AddSendData                = 20,
    ApiId_ClearSendData              = 21,
    //受信
    ApiId_AddReceiveData             = 30,
    ApiId_ClearReceiveData           = 31,
    ApiId_ClearDataIdFilter          = 32,
    //スキャン
    ApiId_StartDeviceScan            = 40,
    ApiId_CancelDeviceScan           = 41,
    //System
    ApiId_System_Received            = 100,
    ApiId_System_DeviceScanFinished  = 101,
};

struct ApiParam_Initialize
{
    Context* pContext;
};
NN_STATIC_ASSERT(sizeof(ApiParam_Initialize) <= Message::DataSizeMax);

struct ApiParam_Finalize
{
    Handle handle;
};
NN_STATIC_ASSERT(sizeof(ApiParam_Finalize) <= Message::DataSizeMax);

struct ApiParam_AddSendData
{
    Handle handle;
    SendDataDescription sdd;
};
NN_STATIC_ASSERT(sizeof(ApiParam_AddSendData) <= Message::DataSizeMax);

struct ApiParam_ClearSendData
{
    Handle handle;
};
NN_STATIC_ASSERT(sizeof(ApiParam_ClearSendData) <= Message::DataSizeMax);

struct ApiParam_AddReceiveData
{
    ReceiveDataDescription rdd;
};
NN_STATIC_ASSERT(sizeof(ApiParam_AddReceiveData) <= Message::DataSizeMax);

struct ApiParam_StartDeviceScan
{
    Handle handle;
};
NN_STATIC_ASSERT(sizeof(ApiParam_StartDeviceScan) <= Message::DataSizeMax);

struct ApiParam_CancelDeviceScan
{
    Handle handle;
};
NN_STATIC_ASSERT(sizeof(ApiParam_CancelDeviceScan) <= Message::DataSizeMax);

}}

