﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      ndd モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_NDD_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NDD_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NDD_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NDD_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NDD_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NDD_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NDD_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NDD_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NDD_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NDD_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NDD_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NDD_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NDD_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NDD_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NDD_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NDD_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NDD_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NDD_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NDD_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NDD_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ndd, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NDD_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Trace, 0, format, args)
#define NN_DETAIL_NDD_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Trace, 1, format, args)
#define NN_DETAIL_NDD_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Trace, 2, format, args)
#define NN_DETAIL_NDD_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Trace, 3, format, args)

#define NN_DETAIL_NDD_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Info, 0, format, args)
#define NN_DETAIL_NDD_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Info, 1, format, args)
#define NN_DETAIL_NDD_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Info, 2, format, args)
#define NN_DETAIL_NDD_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Info, 3, format, args)

#define NN_DETAIL_NDD_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Warn, 0, format, args)
#define NN_DETAIL_NDD_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Warn, 1, format, args)
#define NN_DETAIL_NDD_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Warn, 2, format, args)
#define NN_DETAIL_NDD_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Warn, 3, format, args)

#define NN_DETAIL_NDD_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Error, 0, format, args)
#define NN_DETAIL_NDD_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Error, 1, format, args)
#define NN_DETAIL_NDD_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Error, 2, format, args)
#define NN_DETAIL_NDD_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Error, 3, format, args)

#define NN_DETAIL_NDD_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Fatal, 0, format, args)
#define NN_DETAIL_NDD_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Fatal, 1, format, args)
#define NN_DETAIL_NDD_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Fatal, 2, format, args)
#define NN_DETAIL_NDD_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ndd, Fatal, 3, format, args)

#define NN_DETAIL_NDD_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Trace, 0, text, length)
#define NN_DETAIL_NDD_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Trace, 1, text, length)
#define NN_DETAIL_NDD_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Trace, 2, text, length)
#define NN_DETAIL_NDD_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Trace, 3, text, length)

#define NN_DETAIL_NDD_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Info, 0, text, length)
#define NN_DETAIL_NDD_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Info, 1, text, length)
#define NN_DETAIL_NDD_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Info, 2, text, length)
#define NN_DETAIL_NDD_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Info, 3, text, length)

#define NN_DETAIL_NDD_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Warn, 0, text, length)
#define NN_DETAIL_NDD_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Warn, 1, text, length)
#define NN_DETAIL_NDD_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Warn, 2, text, length)
#define NN_DETAIL_NDD_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Warn, 3, text, length)

#define NN_DETAIL_NDD_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Error, 0, text, length)
#define NN_DETAIL_NDD_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Error, 1, text, length)
#define NN_DETAIL_NDD_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Error, 2, text, length)
#define NN_DETAIL_NDD_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Error, 3, text, length)

#define NN_DETAIL_NDD_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Fatal, 0, text, length)
#define NN_DETAIL_NDD_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Fatal, 1, text, length)
#define NN_DETAIL_NDD_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Fatal, 2, text, length)
#define NN_DETAIL_NDD_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ndd, Fatal, 3, text, length)
