﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_Types.h>
#include <nn/nd/nd_NeighborInfoForSystem.h>
#include <nn/ndd/ndd_Types.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace nd { namespace service { // NOLINT(whitespace/braces)

class IScannerForSystem;

class IServiceBase;

class IServiceForApplication;

class IServiceForSystem;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IScannerForSystem, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IScannerForSystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StartScan)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelScan)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>& outInfo, const ::nn::account::Uid& uid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IScannerForSystem)

        ::nn::Result StartScan() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StartScan);
        }

        ::nn::Result CancelScan() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelScan);
        }

        ::nn::Result GetSystemEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemEvent, (pOutHandle));
        }

        ::nn::Result GetScanResult(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>& outInfo, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetScanResult, (pOutCount, outInfo, uid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IScannerForSystem
    {
    public:
        nn::Result StartScan() NN_NOEXCEPT;
        nn::Result CancelScan() NN_NOEXCEPT;
        nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
        nn::Result GetScanResult(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result StartScan() NN_NOEXCEPT;
    nn::Result CancelScan() NN_NOEXCEPT;
    nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    nn::Result GetScanResult(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nd::service::IScannerForSystem))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartScan)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StartScan);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelScan)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelScan);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemEvent, (pOutHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>& outInfo, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetScanResult, (pOutCount, outInfo, uid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nd::service::IScannerForSystem>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nd::service::IScannerForSystem))

    // nn::Result StartScan() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartScan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartScan)

    // nn::Result CancelScan() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelScan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelScan)

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemEvent)

    // nn::Result GetScanResult(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetScanResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outInfo, 0, (const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetScanResult)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nd::NeighborInfoForSystem), 392, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nd::service::IScannerForSystem, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nd::service::IScannerForSystem))

    // nn::Result StartScan() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartScan)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartScan)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartScan)
    }

    // nn::Result CancelScan() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelScan)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelScan)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelScan)
    }

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemEvent)
    }

    // nn::Result GetScanResult(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>& outInfo, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetScanResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetScanResult)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nd::service::IScannerForSystem>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nd::service::IScannerForSystem))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetScanResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetScanResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetScanResult)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nd::service::IScannerForSystem))

namespace nn { namespace nd { namespace service { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IServiceBase, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IServiceBase)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IServiceBase)

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IServiceBase
    {
    public:
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nd::service::IServiceBase))

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nd::service::IServiceBase>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nd::service::IServiceBase))

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nd::service::IServiceBase, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nd::service::IServiceBase))

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nd::service::IServiceBase>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nd::service::IServiceBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nd::service::IServiceBase))

namespace nn { namespace nd { namespace service { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IServiceForApplication, (::nn::nd::service::IServiceBase))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IServiceForApplication)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetApplicationData, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearApplicationData, (const ::nn::account::Uid& uid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IServiceForApplication)

        ::nn::Result SetApplicationData(const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), buffer)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = buffer)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetApplicationData, (uid, buffer));
        }

        ::nn::Result ClearApplicationData(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearApplicationData, (uid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IServiceForApplication : public ::nn::nd::service::IServiceBase
    {
    public:
        nn::Result SetApplicationData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result ClearApplicationData(const nn::account::Uid& uid) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetApplicationData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result ClearApplicationData(const nn::account::Uid& uid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::nd::service::IServiceForApplication), (::nn::nd::service::IServiceBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetApplicationData, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetApplicationData, (uid, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearApplicationData, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearApplicationData, (uid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nd::service::IServiceForApplication>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::nd::service::IServiceForApplication), (::nn::nd::service::IServiceBase))

    // nn::Result SetApplicationData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetApplicationData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetApplicationData)

    // nn::Result ClearApplicationData(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearApplicationData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearApplicationData)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nd::service::IServiceForApplication, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::nd::service::IServiceForApplication), (::nn::nd::service::IServiceBase))

    // nn::Result SetApplicationData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetApplicationData, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetApplicationData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetApplicationData)
    }

    // nn::Result ClearApplicationData(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearApplicationData, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearApplicationData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearApplicationData)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nd::service::IServiceForApplication>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::nd::service::IServiceForApplication), (::nn::nd::service::IServiceBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetApplicationData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetApplicationData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearApplicationData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearApplicationData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetApplicationData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearApplicationData)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nd::service::IServiceForApplication))

namespace nn { namespace nd { namespace service { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IServiceForSystem, (::nn::nd::service::IServiceBase))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IServiceForSystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemData, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearSystemData, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNeighborInfoUpdateEventForSystem, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivableNeighborInfoCountForSystem, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveNeighborInfoForSystem, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>& outInfo, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSender, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSender, (::nn::sf::Out<bool> pOutSenderExists, ::nn::sf::Out<::nn::account::Uid> pOutSender))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateScannerForSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nd::service::IScannerForSystem>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddReceivedNeighborInfoForSystemForDebug, (const ::nn::sf::InArray<::nn::nd::NeighborInfoForSystem>& info))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSendDataForDebug, (::nn::sf::Out<::nn::ndd::SendDataDescription> pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearReceiveCounterForDebug, (const ::nn::account::Uid& uid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IServiceForSystem)

        ::nn::Result SetSystemData(const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), buffer)), "_.GetPointerUnsafe() != nullptr && _.GetSize() > 0 (where _ = buffer)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSystemData, (uid, buffer));
        }

        ::nn::Result ClearSystemData(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearSystemData, (uid));
        }

        ::nn::Result GetNeighborInfoUpdateEventForSystem(::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNeighborInfoUpdateEventForSystem, (pOutHandle));
        }

        ::nn::Result GetReceivableNeighborInfoCountForSystem(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReceivableNeighborInfoCountForSystem, (pOutCount, uid));
        }

        ::nn::Result ReceiveNeighborInfoForSystem(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>& outInfo, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReceiveNeighborInfoForSystem, (pOutCount, outInfo, uid));
        }

        ::nn::Result SetSender(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSender, (uid));
        }

        ::nn::Result GetSender(::nn::sf::Out<bool> pOutSenderExists, ::nn::sf::Out<::nn::account::Uid> pOutSender) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSender, (pOutSenderExists, pOutSender));
        }

        ::nn::Result CreateScannerForSystem(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nd::service::IScannerForSystem>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateScannerForSystem, (pOut));
        }

        ::nn::Result AddReceivedNeighborInfoForSystemForDebug(const ::nn::sf::InArray<::nn::nd::NeighborInfoForSystem>& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddReceivedNeighborInfoForSystemForDebug, (info));
        }

        ::nn::Result GetSendDataForDebug(::nn::sf::Out<::nn::ndd::SendDataDescription> pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSendDataForDebug, (pOut, uid));
        }

        ::nn::Result ClearReceiveCounterForDebug(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), uid)), "static_cast<bool>(_) (where _ = uid)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearReceiveCounterForDebug, (uid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IServiceForSystem : public ::nn::nd::service::IServiceBase
    {
    public:
        nn::Result SetSystemData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result ClearSystemData(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetNeighborInfoUpdateEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
        nn::Result GetReceivableNeighborInfoCountForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result ReceiveNeighborInfoForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result SetSender(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetSender(nn::sf::Out<bool> pOutSenderExists, nn::sf::Out<nn::account::Uid> pOutSender) NN_NOEXCEPT;
        nn::Result CreateScannerForSystem(nn::sf::Out<nn::sf::SharedPointer<nn::nd::service::IScannerForSystem>> pOut) NN_NOEXCEPT;
        nn::Result AddReceivedNeighborInfoForSystemForDebug(const nn::sf::InArray<nn::nd::NeighborInfoForSystem>& info) NN_NOEXCEPT;
        nn::Result GetSendDataForDebug(nn::sf::Out<nn::ndd::SendDataDescription> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result ClearReceiveCounterForDebug(const nn::account::Uid& uid) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetSystemData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result ClearSystemData(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetNeighborInfoUpdateEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    nn::Result GetReceivableNeighborInfoCountForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ReceiveNeighborInfoForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result SetSender(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetSender(nn::sf::Out<bool> pOutSenderExists, nn::sf::Out<nn::account::Uid> pOutSender) NN_NOEXCEPT;
    nn::Result CreateScannerForSystem(nn::sf::Out<nn::sf::SharedPointer<nn::nd::service::IScannerForSystem>> pOut) NN_NOEXCEPT;
    nn::Result AddReceivedNeighborInfoForSystemForDebug(const nn::sf::InArray<nn::nd::NeighborInfoForSystem>& info) NN_NOEXCEPT;
    nn::Result GetSendDataForDebug(nn::sf::Out<nn::ndd::SendDataDescription> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ClearReceiveCounterForDebug(const nn::account::Uid& uid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::nd::service::IServiceForSystem), (::nn::nd::service::IServiceBase))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemData, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSystemData, (uid, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearSystemData, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearSystemData, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNeighborInfoUpdateEventForSystem, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNeighborInfoUpdateEventForSystem, (pOutHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivableNeighborInfoCountForSystem, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReceivableNeighborInfoCountForSystem, (pOutCount, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveNeighborInfoForSystem, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>& outInfo, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReceiveNeighborInfoForSystem, (pOutCount, outInfo, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSender, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSender, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSender, (::nn::sf::Out<bool> pOutSenderExists, ::nn::sf::Out<::nn::account::Uid> pOutSender))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSender, (pOutSenderExists, pOutSender));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateScannerForSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nd::service::IScannerForSystem>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateScannerForSystem, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddReceivedNeighborInfoForSystemForDebug, (const ::nn::sf::InArray<::nn::nd::NeighborInfoForSystem>& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddReceivedNeighborInfoForSystemForDebug, (info));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSendDataForDebug, (::nn::sf::Out<::nn::ndd::SendDataDescription> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSendDataForDebug, (pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearReceiveCounterForDebug, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearReceiveCounterForDebug, (uid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nd::service::IServiceForSystem>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::nd::service::IServiceForSystem), (::nn::nd::service::IServiceBase))

    // nn::Result SetSystemData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSystemData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSystemData)

    // nn::Result ClearSystemData(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearSystemData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearSystemData)

    // nn::Result GetNeighborInfoUpdateEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNeighborInfoUpdateEventForSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNeighborInfoUpdateEventForSystem)

    // nn::Result GetReceivableNeighborInfoCountForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReceivableNeighborInfoCountForSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReceivableNeighborInfoCountForSystem)

    // nn::Result ReceiveNeighborInfoForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReceiveNeighborInfoForSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outInfo, 0, (const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReceiveNeighborInfoForSystem)

    // nn::Result SetSender(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSender)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSender)

    // nn::Result GetSender(nn::sf::Out<bool> pOutSenderExists, nn::sf::Out<nn::account::Uid> pOutSender) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSender)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSenderExists, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSender, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutSenderExists, pOutSender))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSenderExists), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSender)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSender)

    // nn::Result CreateScannerForSystem(nn::sf::Out<nn::sf::SharedPointer<nn::nd::service::IScannerForSystem>> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateScannerForSystem)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateScannerForSystem)

    // nn::Result AddReceivedNeighborInfoForSystemForDebug(const nn::sf::InArray<nn::nd::NeighborInfoForSystem>& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddReceivedNeighborInfoForSystemForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(info, 0, (const ::nn::sf::InArray<::nn::nd::NeighborInfoForSystem>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (info))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddReceivedNeighborInfoForSystemForDebug)

    // nn::Result GetSendDataForDebug(nn::sf::Out<nn::ndd::SendDataDescription> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSendDataForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::ndd::SendDataDescription>), 1216, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSendDataForDebug)

    // nn::Result ClearReceiveCounterForDebug(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearReceiveCounterForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearReceiveCounterForDebug)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nd::NeighborInfoForSystem), 392, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ndd::SendDataDescription), 1216, 2)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nd::service::IServiceForSystem, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::nd::service::IServiceForSystem), (::nn::nd::service::IServiceBase))

    // nn::Result SetSystemData(const nn::account::Uid& uid, const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSystemData, (const ::nn::account::Uid& uid, const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSystemData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSystemData)
    }

    // nn::Result ClearSystemData(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearSystemData, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearSystemData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearSystemData)
    }

    // nn::Result GetNeighborInfoUpdateEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNeighborInfoUpdateEventForSystem, (::nn::sf::Out<::nn::sf::NativeHandle> pOutHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNeighborInfoUpdateEventForSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNeighborInfoUpdateEventForSystem)
    }

    // nn::Result GetReceivableNeighborInfoCountForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivableNeighborInfoCountForSystem, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReceivableNeighborInfoCountForSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReceivableNeighborInfoCountForSystem)
    }

    // nn::Result ReceiveNeighborInfoForSystem(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::nd::NeighborInfoForSystem>& outInfo, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReceiveNeighborInfoForSystem, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::nd::NeighborInfoForSystem>& outInfo, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReceiveNeighborInfoForSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReceiveNeighborInfoForSystem)
    }

    // nn::Result SetSender(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSender, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSender)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSender)
    }

    // nn::Result GetSender(nn::sf::Out<bool> pOutSenderExists, nn::sf::Out<nn::account::Uid> pOutSender) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSender, (::nn::sf::Out<bool> pOutSenderExists, ::nn::sf::Out<::nn::account::Uid> pOutSender))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSender)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSenderExists)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSender)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSender)
    }

    // nn::Result CreateScannerForSystem(nn::sf::Out<nn::sf::SharedPointer<nn::nd::service::IScannerForSystem>> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateScannerForSystem, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nd::service::IScannerForSystem>> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateScannerForSystem)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateScannerForSystem)
    }

    // nn::Result AddReceivedNeighborInfoForSystemForDebug(const nn::sf::InArray<nn::nd::NeighborInfoForSystem>& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddReceivedNeighborInfoForSystemForDebug, (const ::nn::sf::InArray<::nn::nd::NeighborInfoForSystem>& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddReceivedNeighborInfoForSystemForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddReceivedNeighborInfoForSystemForDebug)
    }

    // nn::Result GetSendDataForDebug(nn::sf::Out<nn::ndd::SendDataDescription> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSendDataForDebug, (::nn::sf::Out<::nn::ndd::SendDataDescription> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSendDataForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSendDataForDebug)
    }

    // nn::Result ClearReceiveCounterForDebug(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearReceiveCounterForDebug, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearReceiveCounterForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearReceiveCounterForDebug)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nd::service::IServiceForSystem>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::nd::service::IServiceForSystem), (::nn::nd::service::IServiceBase))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSystemData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetPointerUnsafe() != nullptr && _.GetSize() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSystemData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearSystemData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearSystemData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNeighborInfoUpdateEventForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNeighborInfoUpdateEventForSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReceivableNeighborInfoCountForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReceivableNeighborInfoCountForSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReceiveNeighborInfoForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReceiveNeighborInfoForSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSender)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSender)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSender)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSender)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSenderExists),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSender)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateScannerForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nd::service::IScannerForSystem>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateScannerForSystem)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddReceivedNeighborInfoForSystemForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(info)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddReceivedNeighborInfoForSystemForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSendDataForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSendDataForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearReceiveCounterForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (static_cast<bool>(_)), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearReceiveCounterForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSystemData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearSystemData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNeighborInfoUpdateEventForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReceivableNeighborInfoCountForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReceiveNeighborInfoForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSender)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSender)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateScannerForSystem)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddReceivedNeighborInfoForSystemForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSendDataForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearReceiveCounterForDebug)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nd::service::IServiceForSystem))
