﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace migration { namespace user {

class StateController
{
public:
    virtual Result SetStateInInitialization() NN_NOEXCEPT = 0;
    virtual Result SetStateInTransfer() NN_NOEXCEPT = 0;
    virtual Result SetStateInFinalization() NN_NOEXCEPT = 0;
    virtual Result SetStateFinalized() NN_NOEXCEPT = 0;
    virtual void Reset() NN_NOEXCEPT = 0;

    virtual bool IsResumable() const NN_NOEXCEPT = 0;
    virtual bool IsInitialized() const NN_NOEXCEPT = 0;
    virtual bool IsTransferDone() const NN_NOEXCEPT = 0;
    virtual bool IsFinalized() const NN_NOEXCEPT = 0;
};

}}} // ~namespace nn::migration::user
