﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/migration/migration_UserMigrationTypes.h>

namespace nn { namespace migration { namespace user {

enum MigrationRole
    : uint32_t
{
    MigrationRole_Server,
    MigrationRole_Client,
};

enum MigrationState
    : uint32_t
{
    MigrationState_Started,
    MigrationState_InInitialization,
    MigrationState_InTransfer,
    MigrationState_InFinalization,
    MigrationState_Finalized,
};

struct LastMigrationInfo
{
    MigrationRole role;
    MigrationState state;
};

inline bool IsValidState(MigrationState state) NN_NOEXCEPT
{
    switch (state)
    {
    case MigrationState_Started:
    case MigrationState_InInitialization:
    case MigrationState_InTransfer:
    case MigrationState_InFinalization:
    case MigrationState_Finalized:
        return true;
    default:
        return false;
    }
}

inline bool IsResumable(MigrationState state) NN_NOEXCEPT
{
    switch (state)
    {
    case MigrationState_Started:
        return false;
    case MigrationState_InInitialization:
    case MigrationState_InTransfer:
    case MigrationState_InFinalization:
    case MigrationState_Finalized:
        return true;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

inline LastUserMigrationState Convert(const LastMigrationInfo& o) NN_NOEXCEPT
{
    switch (o.role)
    {
    case MigrationRole_Client:
        switch (o.state)
        {
        case MigrationState_Started:
            return LastUserMigrationState::Unresumable;
        case MigrationState_InInitialization:
        case MigrationState_InTransfer:
            return LastUserMigrationState::ClientResumable;
        case MigrationState_InFinalization:
        case MigrationState_Finalized:
            return LastUserMigrationState::ClientResumeSuggested;
        default:
            NN_UNEXPECTED_DEFAULT;
        }
        break;

    case MigrationRole_Server:
        switch (o.state)
        {
        case MigrationState_Started:
            return LastUserMigrationState::Unresumable;
        case MigrationState_InInitialization:
        case MigrationState_InTransfer:
            return LastUserMigrationState::ServerResumable;
        case MigrationState_InFinalization:
        case MigrationState_Finalized:
            return LastUserMigrationState::ServerResumeSuggested;
        default:
            NN_UNEXPECTED_DEFAULT;
        }
        break;

    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

}}} // ~namespace nn::migration::user
