﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_TypesForSystemServices.h>
#include <nn/migration/migration_Types.h>
#include <nn/util/util_Uuid.h>

namespace nn { namespace migration {

/**
    @brief クライアントやサーバーの作成時にに与えるべきメモリ量
*/
const size_t RequiredWorkBufferSizeForUserMigrationOperation = 16 * 1024 * 1024;

/**
    @brief 最後に行ったユーザー移行の再開に関する状態
*/
enum class LastUserMigrationState
{
    Unresumable, //!< 再開できない
    ServerResumable, //!< サーバーを再開できる
    ServerResumeSuggested, //!< ユーザーデータの損失を防ぐため、サーバーを再開することが推奨される
    ClientResumable, //!< クライアントを再開できる
    ClientResumeSuggested, //!< ユーザーデータの損失を防ぐため、クライアントを再開することが推奨される
};

/**
    @brief ユーザー移行のサーバーに設定可能な任意のデータ
*/
struct UserMigrationServerProfile
{
    Bit8 data[256];
};

/**
    @brief ユーザー移行のクライアントに設定可能な任意のデータ
*/
struct UserMigrationClientProfile
{
    Bit8 data[256];
};

/**
    @brief ユーザー移行の接続先となるサーバーの情報
*/
struct UserMigrationServerInfo
{
    util::Uuid id;
    UserMigrationServerProfile profile;
};

}} // ~namespace nn::migration
