﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/migration/detail/migration_Cancellable.h>
#include <nn/migration/idc/detail/migration_Util.h>

namespace nn { namespace migration { namespace idc {

/**
* @brief ソケットによる通信路の実装。
*/
class SocketConnection
{
    friend void swap(SocketConnection& o0, SocketConnection& o1) NN_NOEXCEPT;
    NN_DISALLOW_COPY(SocketConnection);

public:
    SocketConnection() NN_NOEXCEPT;
    explicit SocketConnection(int socketDescriptor) NN_NOEXCEPT;
    SocketConnection(SocketConnection&& rhs) NN_NOEXCEPT;
    ~SocketConnection() NN_NOEXCEPT;

    SocketConnection& operator =(SocketConnection&& rhs) NN_NOEXCEPT;

    Result Send(size_t* pOutSentSize, const void* stream, size_t size, int timeoutSeconds, const migration::detail::Cancellable* pCancellable, detail::TransferSpeedMonitor* pSpeedMonitor = nullptr) const NN_NOEXCEPT;
    Result Receive(size_t* pOutReceivedSize, void* outStream, size_t outStreamSize, int timeoutSeconds, const migration::detail::Cancellable* pCancellable, detail::TransferSpeedMonitor* pSpeedMonitor = nullptr) const NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;

private:
    int m_SocketDescriptor;
};

}}}
