﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/migration/detail/migration_SharedResource.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace migration { namespace detail {

template <size_t HeapSize>
class ServiceObjectAllocator
    : public sf::ExpHeapAllocator
{
    NN_DISALLOW_COPY(ServiceObjectAllocator);
    NN_DISALLOW_MOVE(ServiceObjectAllocator);

private:
    typename std::aligned_storage<HeapSize>::type m_Storage;
    lmem::HeapHandle m_HeapHandle;
    detail::Counter m_Counter;
public:
    typedef sf::ObjectFactory<sf::ExpHeapAllocator::Policy> Factory;

    ServiceObjectAllocator() NN_NOEXCEPT
    {
        m_HeapHandle = lmem::CreateExpHeap(&m_Storage, sizeof(m_Storage), 0);
        this->Attach(m_HeapHandle);
    }
    ~ServiceObjectAllocator() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS(m_Counter.Get() == 0);
        this->Detach();
        lmem::DestroyExpHeap(m_HeapHandle);
    }
    SharedResource<ServiceObjectAllocator<HeapSize>> GetShared() NN_NOEXCEPT
    {
        return SharedResource<ServiceObjectAllocator<HeapSize>>(*this, m_Counter);
    }
};

}}} // ~namespace nn::migration::detail
