﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/nifm/nifm_TypesRequirement.h>

namespace nn { namespace migration { namespace detail {

Result ConnectToInternet(nifm::NetworkConnection& connection, nifm::RequirementPreset preset, const Cancellable* pCancellable) NN_NOEXCEPT;

}}} // ~namesapce nn::migration::detail


#include <nn/migration/migration_Result.h>
#include <nn/migration/detail/migration_Cancellable.h>
#include <nn/migration/detail/migration_Diagnosis.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace migration { namespace detail {

inline Result ConnectToInternet(nifm::NetworkConnection& connection, nifm::RequirementPreset preset, const Cancellable* pCancellable) NN_NOEXCEPT
{
    NN_RESULT_DO(nifm::SetRequestRequirementPreset(connection.GetRequestHandle(), preset));
    connection.SubmitRequest();

    auto& e = connection.GetSystemEvent();
    auto isSignaled = detail::CancellableWait<500>(e, pCancellable);
    if (!isSignaled)
    {
        connection.CancelRequest();
        NN_SDK_ASSERT(e.TryWait());
    }
    e.Clear();
    NN_SDK_ASSERT(!connection.IsRequestOnHold());

    NN_RESULT_THROW_UNLESS(isSignaled, ResultCanceled());
    NN_RESULT_THROW_UNLESS(connection.IsAvailable(), ResultInternetConnectionUnavailable());
    NN_RESULT_SUCCESS;
}

}}} // ~namesapce nn::migration::detail
