﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ldn
{
    //
    // SF の HIPC/DFC 呼出しを切り替えるスイッチです。
    //
    // NN_LDN_BUILD_CONFIG_SF_DFC
    // SF で DFC を使用します。
    //
    // NN_LDN_BUILD_CONFIG_SF_HIPC
    // SF で HIPC (Horizon IPC) を使用します。
    //
    #if NN_BUILD_CONFIG_OS_WIN
        #define NN_LDN_BUILD_CONFIG_SF_DFC 1
    #elif NN_BUILD_CONFIG_OS_HORIZON
        #define NN_LDN_BUILD_CONFIG_SF_HIPC 1
    #else
        #error unknown operating system
    #endif

    //
    // SPL の使用を切り替えるスイッチです。
    //
    // NN_LDN_BUILD_CONFIG_SPL_ENABLED
    // SPL を使用して鍵の生成や製品機の判定を行います。
    //
    // NN_LDN_BUILD_CONFIG_SPL_DISABLED
    // SPL を使用する代わりにソフトウェアで鍵を生成します。また、常に開発機とみなされます。
    //
    #if NN_BUILD_CONFIG_OS_WIN
        #define NN_LDN_BUILD_CONFIG_SPL_DISABLED 1
    #elif NN_BUILD_CONFIG_OS_HORIZON
        #define NN_LDN_BUILD_CONFIG_SPL_ENABLED 1
    #else
        #error unknown operating system
    #endif

    //
    // セキュリティ・モードの設定を切り替えるスイッチです。
    // ここでの指定は製品機では意味をもちません。
    //
    // NN_LDN_BUILD_CONFIG_SECURITY_MODE_PRODUCT
    // 常に SecurityMode_Product を使用します。
    // データ通信、 Advertise ともに暗号化されます。
    //
    // NN_LDN_BUILD_CONFIG_SECURITY_MODE_DEBUG
    // 常に SecurityMode_Debug を使用します。
    // Advertise のみ暗号化されます。
    //
    // NN_LDN_BUILD_CONFIG_SECURITY_MODE_SYSTEM_DEBUG
    // 常に SecurityMode_SystemDebug を使用します。
    // データ通信、 Advertise ともに暗号化されません。
    //
    // NN_LDN_BUILD_CONFIG_SECURITY_MODE_MANUAL
    // SecurityMode を上位層から指定します。
    //
    #define NN_LDN_BUILD_CONFIG_SECURITY_MODE_MANUAL 1

    //
    // 不完全な Advertise の受信許可・禁止を切り替えるスイッチです。
    //
    // NN_LDN_BUILD_CONFIG_INCOMPLETE_ADVERTISE_PERMITTED
    // データサイズや署名の検証を無視して不完全な Advertise の受信を許可します。
    //
    // NN_LDN_BUILD_CONFIG_INCOMPLETE_ADVERTISE_FORBIDDEN
    // データサイズや署名の検証を実施して不完全な Advertise を破棄します。
    //
    // 製品環境では検証を行うべきです。
    // NN_LDN_BUILD_CONFIG_INCOMPLETE_ADVERTISE_FORBIDDEN を定義してリリースします。
    //
    #define NN_LDN_BUILD_CONFIG_INCOMPLETE_ADVERTISE_FORBIDDEN 1

    //
    // 無線チャンネルを切り替えるスイッチです。
    // ここでの指定は製品機では意味をもたず、製品機では常に自動選択されます。
    //
    // NN_LDN_BUILD_CONFIG_CHANNEL_AUTO
    // 常に無線チャンネルを自動選択します。
    //
    // NN_LDN_BUILD_CONFIG_CHANNEL_SETTINGS
    // 無線チャンネルの選択ポリシーは Settings に従います。
    //
    // NN_LDN_BUILD_CONFIG_CHANNEL_RAW
    // 上位層から指定された無線チャンネルをそのまま使用します。
    //
    // NN_LDN_BUILD_CONFIG_CHANNEL_STATIC
    // ビルド時に無線チャンネルを静的に決定します。
    // 使用する無線チャンネルは NN_LDN_BUILD_CONFIG_CHANNEL で指定してください。
    //
    #if NN_BUILD_CONFIG_OS_WIN
        #define NN_LDN_BUILD_CONFIG_CHANNEL_RAW 1
    #elif NN_BUILD_CONFIG_OS_HORIZON
        #define NN_LDN_BUILD_CONFIG_CHANNEL_SETTINGS 1
    #else
        #error unknown operating system
    #endif
    #define NN_LDN_BUILD_CONFIG_CHANNEL 1 //ch

    //
    // ローカル通信識別子の検証方法を切り替えるスイッチです。
    //
    // NN_LDN_BUILD_CONFIG_LOCAL_ID_CHECK_DISABLED
    // ローカル通信識別子の検証を実施しません。
    //
    // NN_LDN_BUILD_CONFIG_LOCAL_ID_CHECK_APPLICATION_META
    // アプリケーションのメタ情報を使用してローカル通信識別子を検証します。
    //
    #if NN_BUILD_CONFIG_OS_WIN
        #define NN_LDN_BUILD_CONFIG_LOCAL_ID_CHECK_DISABLED 1
    #elif NN_BUILD_CONFIG_OS_HORIZON
        #define NN_LDN_BUILD_CONFIG_LOCAL_ID_CHECK_APPLICATION_META 1
    #else
        #error unknown operating system
    #endif

}} // end of namespace nn::ldn
