﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/os/os_MutexTypes.h>

namespace nn { namespace lcs { namespace detail
{

    class StateMachine
    {
    public:
        StateMachine() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        State GetState() NN_NOEXCEPT;

        bool SetState(State state) NN_NOEXCEPT;

    private:
        State m_State;
        bool m_IsInitialized;
    };

}}} // end of namespace nn::lcs
