﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkLog.h>

//
// システムデバッグ用のログ出力の有効・無効を切り替えるスイッチです。
//
// NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG
// デバッグレベルのログ出力を有効化します。
//
// NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO
// 情報レベルのログ出力を有効化します。
//
// NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_WARNING
// 警告レベルのログ出力を有効化します。
//
// NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_ERROR
// エラーレベルのログ出力を有効化します。
//
// NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_FATAL
// 深刻なエラーレベルのログ出力を有効化します。
//
// NN_LCS_BUILD_CONFIG_DEBUG_LOG_DISABLED
// ログ出力を無効化します。
//
// アプリ開発者にシステムログを見せる必要はありませんので、
// 必ず NN_LCS_BUILD_CONFIG_DEBUG_LOG_DISABLED を定義してリリースします。
//
#define NN_LCS_BUILD_CONFIG_DEBUG_LOG_DISABLED 1

#define NN_DETAIL_LCS_LOG_PREFIX(level) "[LCS] (" #level ") "

/**
 * @def           NN_LCS_LOG_DEBUG
 * @brief         デバッグ用のログ出力マクロです。
 * @details       デバッグ時にのみ関心がある情報を知らせるために使用します。
 */
#if defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG)
    #define NN_LCS_LOG_DEBUG(...) NN_SDK_LOG(NN_DETAIL_LCS_LOG_PREFIX(DEBUG) __VA_ARGS__)
    #define NN_LCS_LOG_DEBUG_WITHOUT_PREFIX(...) NN_SDK_LOG(__VA_ARGS__)
#else
    #define NN_LCS_LOG_DEBUG(...)
    #define NN_LCS_LOG_DEBUG_WITHOUT_PREFIX(...)
#endif

/**
 * @def           NN_LCS_LOG_INFO
 * @brief         デバッグ用のログ出力マクロです。
 * @details       想定通りのことが起きた場合に使用します。
 */
#if defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO)
    #define NN_LCS_LOG_INFO(...) NN_SDK_LOG(NN_DETAIL_LCS_LOG_PREFIX(INFO) __VA_ARGS__)
    #define NN_LCS_LOG_INFO_WITHOUT_PREFIX(...) NN_SDK_LOG(__VA_ARGS__)
#else
    #define NN_LCS_LOG_INFO(...)
    #define NN_LCS_LOG_INFO_WITHOUT_PREFIX(...)
#endif

/**
 * @def           NN_LCS_LOG_WARN
 * @brief         デバッグ用のログ出力マクロです。
 * @details       想定外のことが起きた場合に使用します。
 */
#if defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_WARNING)
    #define NN_LCS_LOG_WARN(...) NN_SDK_LOG(NN_DETAIL_LCS_LOG_PREFIX(WARNING) __VA_ARGS__)
    #define NN_LCS_LOG_WARN_WITHOUT_PREFIX(...) NN_SDK_LOG(__VA_ARGS__)
#else
    #define NN_LCS_LOG_WARN(...)
    #define NN_LCS_LOG_WARN_WITHOUT_PREFIX(...)
#endif

/**
 * @def           NN_LCS_LOG_ERROR
 * @brief         デバッグ用のログ出力マクロです。
 * @details       一部の機能を実行できない場合に使用します。
 */
#if defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_WARNING) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_ERROR)
    #define NN_LCS_LOG_ERROR(...) NN_SDK_LOG(NN_DETAIL_LCS_LOG_PREFIX(ERROR) __VA_ARGS__)
    #define NN_LCS_LOG_ERROR_WITHOUT_PREFIX(...) NN_SDK_LOG(__VA_ARGS__)
#else
    #define NN_LCS_LOG_ERROR(...)
    #define NN_LCS_LOG_ERROR_WITHOUT_PREFIX(...)
#endif

/**
 * @def           NN_LCS_LOG_FATAL
 * @brief         デバッグ用のログ出力マクロです。
 * @details       モジュールの実行を継続できない場合に使用します。
 */
#if defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_INFO) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_WARNING) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_ERROR) ||\
    defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_FATAL)
    #define NN_LCS_LOG_FATAL(...) NN_SDK_LOG(NN_DETAIL_LCS_LOG_PREFIX(FATAL) __VA_ARGS__)
    #define NN_LCS_LOG_FATAL_WITHOUT_PREFIX(...) NN_SDK_LOG(__VA_ARGS__)
#else
    #define NN_LCS_LOG_FATAL(...)
    #define NN_LCS_LOG_FATAL_WITHOUT_PREFIX(...)
#endif

/**
 * @def           NN_LCS_TRACE
 * @brief         デバッグ用のトレースログ出力マクロです。
 * @details       関数名と行番号を出力します。
 */
#if defined(NN_LCS_BUILD_CONFIG_DEBUG_LOG_LEVEL_DEBUG)
    #define NN_LCS_TRACE NN_SDK_LOG(NN_DETAIL_LCS_LOG_PREFIX(TRACE) "%s() L.%d\n",\
                            NN_CURRENT_FUNCTION_NAME, __LINE__)
#else
    #define NN_LCS_TRACE
#endif
