﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/kpr/detail/kpr_KeyCodeMap.h>

namespace nn { namespace kpr { namespace detail {

namespace {

const KeyCodeMapStorage KeyCodeMapRussian =
{ { { 0x00000009 } }, 5, 100, 0, {}, {
    CyrilLetter, 0x0061, 0x0041, 0x0444, 0x0424, // A Ф
    CyrilLetter, 0x0062, 0x0042, 0x0438, 0x0418, // B И
    CyrilLetter, 0x0063, 0x0043, 0x0441, 0x0421, // C С
    CyrilLetter, 0x0064, 0x0044, 0x0432, 0x0412, // D В
    CyrilLetter, 0x0065, 0x0045, 0x0443, 0x0423, // E У
    CyrilLetter, 0x0066, 0x0046, 0x0430, 0x0410, // F А
    CyrilLetter, 0x0067, 0x0047, 0x043F, 0x041F, // G П
    CyrilLetter, 0x0068, 0x0048, 0x0440, 0x0420, // H Р
    CyrilLetter, 0x0069, 0x0049, 0x0448, 0x0428, // I Ш
    CyrilLetter, 0x006A, 0x004A, 0x043E, 0x041E, // J О
    CyrilLetter, 0x006B, 0x004B, 0x043B, 0x041B, // K Л
    CyrilLetter, 0x006C, 0x004C, 0x0434, 0x0414, // L Д
    CyrilLetter, 0x006D, 0x004D, 0x044C, 0x042C, // M Ь
    CyrilLetter, 0x006E, 0x004E, 0x0442, 0x0422, // N Т
    CyrilLetter, 0x006F, 0x004F, 0x0449, 0x0429, // O Щ
    CyrilLetter, 0x0070, 0x0050, 0x0437, 0x0417, // P З
    CyrilLetter, 0x0071, 0x0051, 0x0439, 0x0419, // Q Й
    CyrilLetter, 0x0072, 0x0052, 0x043A, 0x041A, // R К
    CyrilLetter, 0x0073, 0x0053, 0x044B, 0x042B, // S Ы
    CyrilLetter, 0x0074, 0x0054, 0x0435, 0x0415, // T Е
    CyrilLetter, 0x0075, 0x0055, 0x0433, 0x0413, // U Г
    CyrilLetter, 0x0076, 0x0056, 0x043C, 0x041C, // V М
    CyrilLetter, 0x0077, 0x0057, 0x0446, 0x0426, // W Ц
    CyrilLetter, 0x0078, 0x0058, 0x0447, 0x0427, // X Ч
    CyrilLetter, 0x0079, 0x0059, 0x043D, 0x041D, // Y Н
    CyrilLetter, 0x007A, 0x005A, 0x044F, 0x042F, // Z Я
    BasicSymbol, 0x0031, 0x0021, 0x0031, 0x0021, // 1 ! 1 !
    BasicSymbol, 0x0032, 0x0040, 0x0032, 0x0022, // 2 @ 2 "
    BasicSymbol, 0x0033, 0x0023, 0x0033, 0x2116, // 3 # 3 №
    BasicSymbol, 0x0034, 0x0024, 0x0034, 0x003B, // 4 $ 4 ;
    BasicSymbol, 0x0035, 0x0025, 0x0035, 0x0025, // 5 % 5 %
    BasicSymbol, 0x0036, 0x005E, 0x0036, 0x003A, // 6 ^ 6 :
    BasicSymbol, 0x0037, 0x0026, 0x0037, 0x003F, // 7 & 7 ?
    BasicSymbol, 0x0038, 0x002A, 0x0038, 0x002A, // 8 * 8 *
    BasicSymbol, 0x0039, 0x0028, 0x0039, 0x0028, // 9 ( 9 (
    BasicSymbol, 0x0030, 0x0029, 0x0030, 0x0029, // 0 ) 0 )
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Enter
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Escape
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Backspace
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Tab
    BasicSymbol, 0x0020, 0x0020, 0x0020, 0x0020, // Space
    BasicSymbol, 0x002D, 0x005F, 0x002D, 0x005F, // - _ - _
    BasicSymbol, 0x003D, 0x002B, 0x003D, 0x002B, // = + = +
    CyrilSymbol, 0x005B, 0x007B, 0x0445, 0x0425, // [ { Х
    CyrilSymbol, 0x005D, 0x007D, 0x044A, 0x042A, // ] } Ъ
    BasicSymbol, 0x005C, 0x007C, 0x005C, 0x002F, // \ | \ /
    BasicSymbol, 0x005C, 0x007C, 0x005C, 0x002F, // \ | \ /
    CyrilSymbol, 0x003B, 0x003A, 0x0436, 0x0416, // ; : Ж
    CyrilSymbol, 0x0027, 0x0022, 0x044D, 0x042D, // ' " Э
    CyrilSymbol, 0x0060, 0x007E, 0x0451, 0x0401, // ` ~ Ё
    CyrilSymbol, 0x002C, 0x003C, 0x0431, 0x0411, // , < Б
    CyrilSymbol, 0x002E, 0x003E, 0x044E, 0x042E, // . > Ю
    BasicSymbol, 0x002F, 0x003F, 0x002E, 0x002C, // / ? . ,
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Caps Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F1
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F2
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F3
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F4
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F5
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F6
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F7
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F8
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F9
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F10
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F11
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // F12
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // PrintScreen
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Scroll Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Pause
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Insert
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Home
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // PageUp
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Delete
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // End
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // PageDown
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // →
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // ←
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // ↓
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // ↑
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Num Lock
    BasicSymbol, 0x002F, 0x002F, 0x002F, 0x002F, // Keypad /
    BasicSymbol, 0x002A, 0x002A, 0x002A, 0x002A, // Keypad *
    BasicSymbol, 0x002D, 0x002D, 0x002D, 0x002D, // Keypad -
    BasicSymbol, 0x002B, 0x002B, 0x002B, 0x002B, // Keypad +
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Keypad Enter
    BasicKeypad, 0x0000, 0x0031, 0x0000, 0x0031, // Keypad 1
    BasicKeypad, 0x0000, 0x0032, 0x0000, 0x0032, // Keypad 2
    BasicKeypad, 0x0000, 0x0033, 0x0000, 0x0033, // Keypad 3
    BasicKeypad, 0x0000, 0x0034, 0x0000, 0x0034, // Keypad 4
    BasicKeypad, 0x0020, 0x0035, 0x0020, 0x0035, // Keypad 5
    BasicKeypad, 0x0000, 0x0036, 0x0000, 0x0036, // Keypad 6
    BasicKeypad, 0x0000, 0x0037, 0x0000, 0x0037, // Keypad 7
    BasicKeypad, 0x0000, 0x0038, 0x0000, 0x0038, // Keypad 8
    BasicKeypad, 0x0000, 0x0039, 0x0000, 0x0039, // Keypad 9
    BasicKeypad, 0x0000, 0x0030, 0x0000, 0x0030, // Keypad 0
    BasicKeypad, 0x0000, 0x002C, 0x0000, 0x002C, // Keypad ,
    BasicSymbol, 0x005C, 0x007C, 0x005C, 0x007C, // \ | \ |
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Application
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, // Power
    BasicSymbol, 0x003D, 0x003D, 0x003D, 0x003D, // Keypad =
} };

} // namespace

}}} // namespace nn::kpr::detail
