﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_TimeSpan.h>
#include <nn/irsensor/irsensor_ImageProcessorTypes.h>

namespace nn { namespace irsensor {

struct PackedMcuVersion
{
    uint16_t major;
    uint16_t minor;
};

struct PackedFunctionLevel
{
    uint8_t level;
    char reserved[3];
};

struct PackedIrCameraConfig
{
    ::nn::TimeSpanType exposureTime;
    int8_t lightTarget;
    int8_t gain;
    bool isNegativeImageUsed;
    NN_STATIC_ASSERT(sizeof(bool) == 1);
    char reserved[5];
};

struct PackedMomentProcessorConfig
{
    PackedIrCameraConfig irCameraConfig;
    Rect windowOfInterest;
    PackedMcuVersion requiredVersion;
    int8_t preprocess;
    uint8_t preprocessIntensityThreshold;
    char reserved[2];
};

struct PackedClusteringProcessorConfig
{
    PackedIrCameraConfig irCameraConfig;
    Rect windowOfInterest;
    PackedMcuVersion requiredVersion;
    int32_t objectPixelCountMin;
    int32_t objectPixelCountMax;
    uint8_t objectIntensityMin;
    bool isExternalLightFilterEnebled;
    NN_STATIC_ASSERT(sizeof(bool) == 1);
    char reserved[2];
};

struct PackedImageTransferProcessorConfig
{
    PackedIrCameraConfig irCameraConfig;
    PackedMcuVersion requiredVersion;
    int8_t format;
    char reserved[3];
};

struct PackedImageTransferProcessorExConfig
{
    PackedIrCameraConfig irCameraConfig;
    PackedMcuVersion requiredVersion;
    int8_t origFormat;
    int8_t trimmingFormat;
    uint16_t trimmingStartX;
    uint16_t trimmingStartY;
    bool isExternalLightFilterEnebled;
    NN_STATIC_ASSERT(sizeof(bool) == 1);
    char reserved[5];
};

struct PackedPointingProcessorConfig
{
    Rect windowOfInterest;
    PackedMcuVersion requiredVersion;
};

struct PackedTeraPluginParameter
{
    int8_t setting;
    int8_t data[2];
};

struct PackedTeraPluginProcessorConfig
{
    PackedMcuVersion requiredVersion;
    int8_t mode;
    PackedTeraPluginParameter param;
};

struct PackedIrLedProcessorConfig
{
    PackedMcuVersion requiredVersion;
    int8_t lightTarget;
    char reserved[3];
};

}} // namespace nn::irsensor
