﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief API declaration for MarkerPlaneEstimation
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/irsensor/irsensor_Result.h>
#include <nn/irsensor/irsensor_MarkerPlaneEstimationTypes.h>

namespace nn { namespace irsensor {

MarkerPlaneHandle MarkerPlaneEstimationInitialize(unsigned char* initMemory, size_t initMemorySize, const MarkerPlaneConfig& config) NN_NOEXCEPT;

void MarkerPlaneEstimationFinalize(MarkerPlaneHandle handle) NN_NOEXCEPT;

::nn::Result UpdateMarkerPlaneEstimation(const PointList& points, MarkerPlaneHandle handle) NN_NOEXCEPT;

::nn::Result GetMarkerPlaneState(MarkerPlaneState* pState, MarkerPlaneHandle handle) NN_NOEXCEPT;

::nn::Result GetBaseReference(PointList* pBaseReference, MarkerPlaneHandle handle) NN_NOEXCEPT;

bool GetCurrentReference(PointList* pCurrentReference, MarkerPlaneHandle handle) NN_NOEXCEPT;

} } // namespace nn::irsensor
