﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief IR カメラに関する Private な型の宣言。
 */

#pragma once

#include <nn/nn_TimeSpan.h>

namespace nn { namespace irsensor {

/**
 * @brief IR カメラの内部状態です。
 */
enum IrCameraInternalStatus
{
    IrCameraInternalStatus_Available,     //!< IR カメラの内部状態は正常です。
    IrCameraInternalStatus_NeedUpdate,    //!< IR カメラは FW のバージョンが古いか、FW のアップデートに失敗しています。
    IrCameraInternalStatus_HardwareError, //!< IR カメラのハードウェアが故障しています。
    IrCameraInternalStatus_NeedCharge,    //!< コントローラの電池残量が少ないため、IR カメラを使用できません。
    IrCameraInternalStatus_HidResourceError, //!< Hid のリソースが足りないため、IR カメラを使用できません。
    IrCameraInternalStatus_CheckVersionIncompleted, //!< IR カメラの FW バージョンのチェックが未完了です。
    IrCameraInternalStatus_NeedUpdateOnInitial,    //!< 起動前のチェックで FW 更新が必要なことがわかりました。
    IrCameraInternalStatus_SuccessfulTerminated,   //!< IR カメラは正常に停止しています。(Addon 4.1.0以前のライブラリから呼ぶ場合は、Available にキャストされます)
    IrCameraInternalStatus_Setting,       //!< IR カメラは設定中です。
};

/**
 * @brief IR センサーの FunctionLevel です。 詳細はマニュアルを参照してください。
 */
enum IrSensorFunctionLevel
{
    IrSensorFunctionLevel_0,                                  //!< 3.0.0 NUP までの機能
    IrSensorFunctionLevel_1,                                  //!< 4.0.0 NUP での機能
    IrSensorFunctionLevel_2,                                  //!< 5.0.0 NUP での機能
    IrSensorFunctionLevel_Latest = IrSensorFunctionLevel_2,   //!< 最新版の機能
};

}} // namespace nn::irsensor
