﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   携帯機状態の入力に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_Common.h>

namespace nn { namespace hid { namespace system {

/**
 * @brief       携帯機モードでのみ有効な Hid デバイスを有効にします。
 *
 * @details     携帯機状態でのみ動作する Hid デバイスを有効にします。
 *              対象となるのは、本体にジョイントされた Joy-Con, タッチスクリーン、本体6軸センサーです。
 *              入力を無効にするためには、DisableHandheldHids() を呼んでください。
 *
 *              システム起動直後の状態は、無効になっています。
 *
 */
void EnableHandheldHids() NN_NOEXCEPT;

/**
 * @brief       携帯機モードでのみ有効な Hid デバイスを無効にします。
 *
 * @details     携帯機状態でのみ動作する Hid デバイスを無効にします。
 *              対象となるのは、本体にジョイントされた Joy-Con, タッチスクリーン、本体6軸センサーです。
 *
 */
void DisableHandheldHids() NN_NOEXCEPT;

}}} // namespace nn::hid::system
