﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Pro Controller 有線 USB 通信機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/hid/hid_NpadCommonTypes.h>

namespace nn { namespace hid {

//! @name Pro Controller 有線 USB 通信機能関連 API
//! @{

/**
 * @brief       本体設定において Pro Controller 有線 USB 通信機能が有効か否かを取得します。
 *
 * @details     アプリケーション実行中でも、本体設定が変更されることで値が変化する場合があります。
 *
 * @return      Pro Controller 有線 USB 通信機能が有効か否かを表す値です。
 */
bool IsUsbFullKeyControllerEnabled() NN_NOEXCEPT;

/**
 * @brief       本体設定に Pro Controller 有線 USB 通信機能の有効/無効を設定します。
 *
 * @details     設定された値は、アプリケーション終了後も本体設定として永続的に保持されます。
 *
 * @param[in]   enable                   Pro Controller 有線 USB 通信機能を有効にするか
 *
 */
void EnableUsbFullKeyController(bool enable) NN_NOEXCEPT;

/**
 * @brief       有線 USB 通信中の Pro Controller かどうかを取得します。
 *
 * @details     Npad ID で指定した Npad に対して、
 *              有線 USB 通信中の Pro Controller かどうかを取得します。
 *
 * @param[in]   id                      Npad ID
 *
 * @return      有線 USB 通信中の Pro Controller かどうかを返します。
 */
bool IsUsbFullKeyControllerConnected(const NpadIdType& id) NN_NOEXCEPT;

//! @}

}} // namespace nn::hid
