﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Npad に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>

namespace nn { namespace hid {

//! @name Npad の十字ボタンの禁則処理関連 API (非公開)
//! @{

/**
 * @brief       十字ボタンの禁則処理の種類を有効/無効を設定します
 *
 * @details     コントローラーのボタンの入力状態を読み出す際の十字ボタンの禁則処理の種類の有無を設定します。
 *              禁則処理の有無は Npad のスタイル毎に設定できます
 *              スタイルを複数同時に指定することで、一度に複数のスタイルに対して設定することが可能です。
 *              禁則処理の有無の初期状態は、Npad の操作スタイル毎に異なります。
 *              詳しくは各 NpadXXXState の説明を確認してください
 *
 *              本関数はアプリケーションで独自に禁則処理などを実装する場合に使用してください。
 *              4つのボタンが分離した方向ボタンが搭載されたコントローラーにおいても、
 *              禁則処理が無効化されることを期待して、上下ボタンまたは左右ボタンの同時押しを必須とするようなゲームの実装は禁止です。
 *
 * @param[in]   style                      設定の対象となる操作スタイル
 * @param[in]   enabled                    禁則処理の有効/無効
 *
 * @pre
 *              - style.CountPopulation() > 0
 */
void EnableControlPadRestriction(const NpadStyleSet& style, bool enabled) NN_NOEXCEPT;


//! @}

}} // namespace nn::hid
