﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/debug/hid_AbstractedPad.h>
#include <nn/hid/debug/hid_CaptureButton.h>
#include <nn/hid/debug/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/debug/hid_DebugPad.h>
#include <nn/hid/debug/hid_FirmwareUpdate.h>
#include <nn/hid/debug/hid_HomeButton.h>
#include <nn/hid/debug/hid_Keyboard.h>
#include <nn/hid/debug/hid_Mouse.h>
#include <nn/hid/debug/hid_SleepButton.h>
#include <nn/hid/debug/hid_Xpad.h>
#include <nn/hid/detail/hid_PadTypes.h>
#include <nn/hid/detail/hid_RxPacketHistoryTypes.h>
#include <nn/hid/detail/hid_SensorTypes.h>
#include <nn/hid/hid_JoyXpad.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/hid_TouchScreen.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/hid/system/hid_FirmwareUpdate.h>
#include <nn/hid/system/hid_NpadCommon.h>
#include <nn/hid/system/hid_RegisteredDevice.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/util/util_MathTypes.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace hid { // NOLINT(whitespace/braces)

class IHidDebugServer;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IHidDebugServer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IHidDebugServer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateDebugPad)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDebugPadAutoPilotState, (const ::nn::hid::debug::DebugPadAutoPilotState& value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnsetDebugPadAutoPilotState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateTouchScreen)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetTouchScreenAutoPilotState, (const ::nn::sf::InArray<::nn::hid::TouchState>& touches))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnsetTouchScreenAutoPilotState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateMouse)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMouseAutoPilotState, (const ::nn::hid::debug::MouseAutoPilotState& value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnsetMouseAutoPilotState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateKeyboard)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetKeyboardAutoPilotState, (const ::nn::hid::debug::KeyboardAutoPilotState& value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnsetKeyboardAutoPilotState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateXpad, (::nn::hid::BasicXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetXpadAutoPilotState, (::nn::hid::BasicXpadId xpadId, const ::nn::hid::debug::BasicXpadAutoPilotState& value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnsetXpadAutoPilotState, (::nn::hid::BasicXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateJoyXpad, (::nn::hid::JoyXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateGesture)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateHomeButton)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetHomeButtonAutoPilotState, (::nn::hid::debug::HomeButtonAutoPilotState value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnsetHomeButtonAutoPilotState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateSleepButton)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSleepButtonAutoPilotState, (::nn::hid::debug::SleepButtonAutoPilotState value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnsetSleepButtonAutoPilotState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateInputDetector)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateCaptureButton)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetCaptureButtonAutoPilotState, (::nn::hid::debug::CaptureButtonAutoPilotState value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnsetCaptureButtonAutoPilotState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetShiftAccelerometerCalibrationValue, (::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetShiftAccelerometerCalibrationValue, (::nn::sf::Out<float> shiftOrigin, ::nn::sf::Out<float> shiftSensitivity, ::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetShiftGyroscopeCalibrationValue, (::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetShiftGyroscopeCalibrationValue, (::nn::sf::Out<float> shiftOrigin, ::nn::sf::Out<float> shiftSensitivity, ::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateConsoleSixAxisSensor)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetConsoleSixAxisSensorSamplingFrequency, (::nn::sf::Out<::std::int64_t> outValue, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateSevenSixAxisSensor)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetConsoleSixAxisSensorCountStates, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::hid::debug::ConsoleSixAxisSensorCountState>& pOutStates, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ActivateFirmwareUpdate)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateFirmwareUpdate)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdate, (::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFirmwareUpdateStage, (::nn::sf::Out<::std::int64_t> outStage, ::nn::sf::Out<::std::int64_t> outProgress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFirmwareVersion, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::NpadIdType id, ::nn::hid::system::NpadDeviceTypeSet deviceType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDestinationFirmwareVersion, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::NpadIdType id, ::nn::hid::system::NpadDeviceTypeSet deviceType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DiscardFirmwareInfoCacheForRevert)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdateForRevert, (::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailableFirmwareVersionForRevert, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsFirmwareUpdatingDevice, (::nn::sf::Out<bool> outValue, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdateIndividual, (::nn::sf::Out<::nn::hid::system::FirmwareUpdateDeviceHandle> outHandle, ::nn::hid::system::UniquePadId id, ::std::int64_t target, ::nn::sf::NativeHandle&& imageHandle, ::std::uint64_t imageSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateControllerColor, (::nn::util::Color4u8Type mainColor, ::nn::util::Color4u8Type subColor, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ConnectUsbPadsAsync)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisconnectUsbPadsAsync)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateDesignInfo, (::nn::util::Color4u8Type mainColor, ::nn::util::Color4u8Type subColor, ::nn::util::Color4u8Type thirdColor, ::nn::util::Color4u8Type forthColor, ::std::uint32_t variation, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUniquePadDriverState, (::nn::sf::Out<::nn::hid::detail::PadDriverState> outState, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorDriverStates, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::hid::detail::SixAxisSensorDriverState>& outStates, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRxPacketHistory, (::nn::sf::Out<::nn::hid::detail::RxPacketHistory> outValue, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireSerialFlashEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadSerialFlash, (::std::uint32_t address, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteSerialFlash, (::std::uint32_t address, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::std::uint64_t writeSize, ::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSerialFlashResult, (::nn::hid::system::UniquePadId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadHandles, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>& pOutHandles))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadState, (::nn::sf::Out<::nn::hid::debug::AbstractedPadState> pOutState, ::nn::hid::debug::AbstractedPadHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadsState, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>& pOutHandles, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadState>& pOutStates))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAutoPilotVirtualPadState, (::nn::hid::debug::AbstractedVirtualPadId virtualPadId, const ::nn::hid::debug::AbstractedPadState& value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnsetAutoPilotVirtualPadState, (::nn::hid::debug::AbstractedVirtualPadId virtualPadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnsetAllAutoPilotVirtualPadState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddRegisteredDevice, (const ::nn::hid::system::RegisteredDevice& device))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IHidDebugServer)

        ::nn::Result DeactivateDebugPad() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateDebugPad);
        }

        ::nn::Result SetDebugPadAutoPilotState(const ::nn::hid::debug::DebugPadAutoPilotState& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDebugPadAutoPilotState, (value));
        }

        ::nn::Result UnsetDebugPadAutoPilotState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnsetDebugPadAutoPilotState);
        }

        ::nn::Result DeactivateTouchScreen() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateTouchScreen);
        }

        ::nn::Result SetTouchScreenAutoPilotState(const ::nn::sf::InArray<::nn::hid::TouchState>& touches) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetTouchScreenAutoPilotState, (touches));
        }

        ::nn::Result UnsetTouchScreenAutoPilotState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnsetTouchScreenAutoPilotState);
        }

        ::nn::Result DeactivateMouse() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateMouse);
        }

        ::nn::Result SetMouseAutoPilotState(const ::nn::hid::debug::MouseAutoPilotState& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMouseAutoPilotState, (value));
        }

        ::nn::Result UnsetMouseAutoPilotState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnsetMouseAutoPilotState);
        }

        ::nn::Result DeactivateKeyboard() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateKeyboard);
        }

        ::nn::Result SetKeyboardAutoPilotState(const ::nn::hid::debug::KeyboardAutoPilotState& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetKeyboardAutoPilotState, (value));
        }

        ::nn::Result UnsetKeyboardAutoPilotState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnsetKeyboardAutoPilotState);
        }

        ::nn::Result DeactivateXpad(::nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeactivateXpad, (xpadId));
        }

        ::nn::Result SetXpadAutoPilotState(::nn::hid::BasicXpadId xpadId, const ::nn::hid::debug::BasicXpadAutoPilotState& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetXpadAutoPilotState, (xpadId, value));
        }

        ::nn::Result UnsetXpadAutoPilotState(::nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnsetXpadAutoPilotState, (xpadId));
        }

        ::nn::Result DeactivateJoyXpad(::nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeactivateJoyXpad, (xpadId));
        }

        ::nn::Result DeactivateGesture() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateGesture);
        }

        ::nn::Result DeactivateHomeButton() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateHomeButton);
        }

        ::nn::Result SetHomeButtonAutoPilotState(::nn::hid::debug::HomeButtonAutoPilotState value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetHomeButtonAutoPilotState, (value));
        }

        ::nn::Result UnsetHomeButtonAutoPilotState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnsetHomeButtonAutoPilotState);
        }

        ::nn::Result DeactivateSleepButton() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateSleepButton);
        }

        ::nn::Result SetSleepButtonAutoPilotState(::nn::hid::debug::SleepButtonAutoPilotState value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSleepButtonAutoPilotState, (value));
        }

        ::nn::Result UnsetSleepButtonAutoPilotState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnsetSleepButtonAutoPilotState);
        }

        ::nn::Result DeactivateInputDetector() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateInputDetector);
        }

        ::nn::Result DeactivateCaptureButton() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateCaptureButton);
        }

        ::nn::Result SetCaptureButtonAutoPilotState(::nn::hid::debug::CaptureButtonAutoPilotState value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetCaptureButtonAutoPilotState, (value));
        }

        ::nn::Result UnsetCaptureButtonAutoPilotState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnsetCaptureButtonAutoPilotState);
        }

        ::nn::Result SetShiftAccelerometerCalibrationValue(::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetShiftAccelerometerCalibrationValue, (handle, aruid, shiftOrigin, shiftSensitivity));
        }

        ::nn::Result GetShiftAccelerometerCalibrationValue(::nn::sf::Out<float> shiftOrigin, ::nn::sf::Out<float> shiftSensitivity, ::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetShiftAccelerometerCalibrationValue, (shiftOrigin, shiftSensitivity, handle, aruid));
        }

        ::nn::Result SetShiftGyroscopeCalibrationValue(::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetShiftGyroscopeCalibrationValue, (handle, aruid, shiftOrigin, shiftSensitivity));
        }

        ::nn::Result GetShiftGyroscopeCalibrationValue(::nn::sf::Out<float> shiftOrigin, ::nn::sf::Out<float> shiftSensitivity, ::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetShiftGyroscopeCalibrationValue, (shiftOrigin, shiftSensitivity, handle, aruid));
        }

        ::nn::Result DeactivateConsoleSixAxisSensor() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateConsoleSixAxisSensor);
        }

        ::nn::Result GetConsoleSixAxisSensorSamplingFrequency(::nn::sf::Out<::std::int64_t> outValue, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetConsoleSixAxisSensorSamplingFrequency, (outValue, aruid));
        }

        ::nn::Result DeactivateSevenSixAxisSensor() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateSevenSixAxisSensor);
        }

        ::nn::Result GetConsoleSixAxisSensorCountStates(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::hid::debug::ConsoleSixAxisSensorCountState>& pOutStates, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetConsoleSixAxisSensorCountStates, (outCount, pOutStates, aruid));
        }

        ::nn::Result ActivateFirmwareUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ActivateFirmwareUpdate);
        }

        ::nn::Result DeactivateFirmwareUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeactivateFirmwareUpdate);
        }

        ::nn::Result StartFirmwareUpdate(::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartFirmwareUpdate, (id));
        }

        ::nn::Result GetFirmwareUpdateStage(::nn::sf::Out<::std::int64_t> outStage, ::nn::sf::Out<::std::int64_t> outProgress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFirmwareUpdateStage, (outStage, outProgress));
        }

        ::nn::Result GetFirmwareVersion(::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::NpadIdType id, ::nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFirmwareVersion, (outValue, id, deviceType));
        }

        ::nn::Result GetDestinationFirmwareVersion(::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::NpadIdType id, ::nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDestinationFirmwareVersion, (outValue, id, deviceType));
        }

        ::nn::Result DiscardFirmwareInfoCacheForRevert() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DiscardFirmwareInfoCacheForRevert);
        }

        ::nn::Result StartFirmwareUpdateForRevert(::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartFirmwareUpdateForRevert, (id));
        }

        ::nn::Result GetAvailableFirmwareVersionForRevert(::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAvailableFirmwareVersionForRevert, (outValue, id));
        }

        ::nn::Result IsFirmwareUpdatingDevice(::nn::sf::Out<bool> outValue, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsFirmwareUpdatingDevice, (outValue, id));
        }

        ::nn::Result StartFirmwareUpdateIndividual(::nn::sf::Out<::nn::hid::system::FirmwareUpdateDeviceHandle> outHandle, ::nn::hid::system::UniquePadId id, ::std::int64_t target, ::nn::sf::NativeHandle&& imageHandle, ::std::uint64_t imageSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartFirmwareUpdateIndividual, (outHandle, id, target, ::std::move(imageHandle), imageSize));
        }

        ::nn::Result UpdateControllerColor(::nn::util::Color4u8Type mainColor, ::nn::util::Color4u8Type subColor, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateControllerColor, (mainColor, subColor, id));
        }

        ::nn::Result ConnectUsbPadsAsync() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ConnectUsbPadsAsync);
        }

        ::nn::Result DisconnectUsbPadsAsync() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisconnectUsbPadsAsync);
        }

        ::nn::Result UpdateDesignInfo(::nn::util::Color4u8Type mainColor, ::nn::util::Color4u8Type subColor, ::nn::util::Color4u8Type thirdColor, ::nn::util::Color4u8Type forthColor, ::std::uint32_t variation, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateDesignInfo, (mainColor, subColor, thirdColor, forthColor, variation, id));
        }

        ::nn::Result GetUniquePadDriverState(::nn::sf::Out<::nn::hid::detail::PadDriverState> outState, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUniquePadDriverState, (outState, id));
        }

        ::nn::Result GetSixAxisSensorDriverStates(::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::hid::detail::SixAxisSensorDriverState>& outStates, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSixAxisSensorDriverStates, (outCount, outStates, id));
        }

        ::nn::Result GetRxPacketHistory(::nn::sf::Out<::nn::hid::detail::RxPacketHistory> outValue, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRxPacketHistory, (outValue, id));
        }

        ::nn::Result AcquireSerialFlashEventHandle(::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireSerialFlashEventHandle, (outValue, id));
        }

        ::nn::Result ReadSerialFlash(::std::uint32_t address, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadSerialFlash, (address, ::std::move(transferMemoryHandle), transferMemorySize, id));
        }

        ::nn::Result WriteSerialFlash(::std::uint32_t address, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::std::uint64_t writeSize, ::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteSerialFlash, (address, ::std::move(transferMemoryHandle), transferMemorySize, writeSize, id));
        }

        ::nn::Result GetSerialFlashResult(::nn::hid::system::UniquePadId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSerialFlashResult, (id));
        }

        ::nn::Result GetAbstractedPadHandles(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>& pOutHandles) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAbstractedPadHandles, (pOutCount, pOutHandles));
        }

        ::nn::Result GetAbstractedPadState(::nn::sf::Out<::nn::hid::debug::AbstractedPadState> pOutState, ::nn::hid::debug::AbstractedPadHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAbstractedPadState, (pOutState, handle));
        }

        ::nn::Result GetAbstractedPadsState(::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>& pOutHandles, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadState>& pOutStates) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAbstractedPadsState, (pOutCount, pOutHandles, pOutStates));
        }

        ::nn::Result SetAutoPilotVirtualPadState(::nn::hid::debug::AbstractedVirtualPadId virtualPadId, const ::nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAutoPilotVirtualPadState, (virtualPadId, value));
        }

        ::nn::Result UnsetAutoPilotVirtualPadState(::nn::hid::debug::AbstractedVirtualPadId virtualPadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnsetAutoPilotVirtualPadState, (virtualPadId));
        }

        ::nn::Result UnsetAllAutoPilotVirtualPadState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnsetAllAutoPilotVirtualPadState);
        }

        ::nn::Result AddRegisteredDevice(const ::nn::hid::system::RegisteredDevice& device) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddRegisteredDevice, (device));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IHidDebugServer
    {
    public:
        nn::Result DeactivateDebugPad() NN_NOEXCEPT;
        nn::Result SetDebugPadAutoPilotState(const nn::hid::debug::DebugPadAutoPilotState& value) NN_NOEXCEPT;
        nn::Result UnsetDebugPadAutoPilotState() NN_NOEXCEPT;
        nn::Result DeactivateTouchScreen() NN_NOEXCEPT;
        nn::Result SetTouchScreenAutoPilotState(const nn::sf::InArray<nn::hid::TouchState>& touches) NN_NOEXCEPT;
        nn::Result UnsetTouchScreenAutoPilotState() NN_NOEXCEPT;
        nn::Result DeactivateMouse() NN_NOEXCEPT;
        nn::Result SetMouseAutoPilotState(const nn::hid::debug::MouseAutoPilotState& value) NN_NOEXCEPT;
        nn::Result UnsetMouseAutoPilotState() NN_NOEXCEPT;
        nn::Result DeactivateKeyboard() NN_NOEXCEPT;
        nn::Result SetKeyboardAutoPilotState(const nn::hid::debug::KeyboardAutoPilotState& value) NN_NOEXCEPT;
        nn::Result UnsetKeyboardAutoPilotState() NN_NOEXCEPT;
        nn::Result DeactivateXpad(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
        nn::Result SetXpadAutoPilotState(nn::hid::BasicXpadId xpadId, const nn::hid::debug::BasicXpadAutoPilotState& value) NN_NOEXCEPT;
        nn::Result UnsetXpadAutoPilotState(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
        nn::Result DeactivateJoyXpad(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
        nn::Result DeactivateGesture() NN_NOEXCEPT;
        nn::Result DeactivateHomeButton() NN_NOEXCEPT;
        nn::Result SetHomeButtonAutoPilotState(nn::hid::debug::HomeButtonAutoPilotState value) NN_NOEXCEPT;
        nn::Result UnsetHomeButtonAutoPilotState() NN_NOEXCEPT;
        nn::Result DeactivateSleepButton() NN_NOEXCEPT;
        nn::Result SetSleepButtonAutoPilotState(nn::hid::debug::SleepButtonAutoPilotState value) NN_NOEXCEPT;
        nn::Result UnsetSleepButtonAutoPilotState() NN_NOEXCEPT;
        nn::Result DeactivateInputDetector() NN_NOEXCEPT;
        nn::Result DeactivateCaptureButton() NN_NOEXCEPT;
        nn::Result SetCaptureButtonAutoPilotState(nn::hid::debug::CaptureButtonAutoPilotState value) NN_NOEXCEPT;
        nn::Result UnsetCaptureButtonAutoPilotState() NN_NOEXCEPT;
        nn::Result SetShiftAccelerometerCalibrationValue(nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT;
        nn::Result GetShiftAccelerometerCalibrationValue(nn::sf::Out<float> shiftOrigin, nn::sf::Out<float> shiftSensitivity, nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result SetShiftGyroscopeCalibrationValue(nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT;
        nn::Result GetShiftGyroscopeCalibrationValue(nn::sf::Out<float> shiftOrigin, nn::sf::Out<float> shiftSensitivity, nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DeactivateConsoleSixAxisSensor() NN_NOEXCEPT;
        nn::Result GetConsoleSixAxisSensorSamplingFrequency(nn::sf::Out<std::int64_t> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DeactivateSevenSixAxisSensor() NN_NOEXCEPT;
        nn::Result GetConsoleSixAxisSensorCountStates(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::hid::debug::ConsoleSixAxisSensorCountState>& pOutStates, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result ActivateFirmwareUpdate() NN_NOEXCEPT;
        nn::Result DeactivateFirmwareUpdate() NN_NOEXCEPT;
        nn::Result StartFirmwareUpdate(nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result GetFirmwareUpdateStage(nn::sf::Out<std::int64_t> outStage, nn::sf::Out<std::int64_t> outProgress) NN_NOEXCEPT;
        nn::Result GetFirmwareVersion(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::NpadIdType id, nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT;
        nn::Result GetDestinationFirmwareVersion(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::NpadIdType id, nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT;
        nn::Result DiscardFirmwareInfoCacheForRevert() NN_NOEXCEPT;
        nn::Result StartFirmwareUpdateForRevert(nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result GetAvailableFirmwareVersionForRevert(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result IsFirmwareUpdatingDevice(nn::sf::Out<bool> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result StartFirmwareUpdateIndividual(nn::sf::Out<nn::hid::system::FirmwareUpdateDeviceHandle> outHandle, nn::hid::system::UniquePadId id, std::int64_t target, nn::sf::NativeHandle&& imageHandle, std::uint64_t imageSize) NN_NOEXCEPT;
        nn::Result UpdateControllerColor(nn::util::Color4u8Type mainColor, nn::util::Color4u8Type subColor, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result ConnectUsbPadsAsync() NN_NOEXCEPT;
        nn::Result DisconnectUsbPadsAsync() NN_NOEXCEPT;
        nn::Result UpdateDesignInfo(nn::util::Color4u8Type mainColor, nn::util::Color4u8Type subColor, nn::util::Color4u8Type thirdColor, nn::util::Color4u8Type forthColor, std::uint32_t variation, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result GetUniquePadDriverState(nn::sf::Out<nn::hid::detail::PadDriverState> outState, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result GetSixAxisSensorDriverStates(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::hid::detail::SixAxisSensorDriverState>& outStates, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result GetRxPacketHistory(nn::sf::Out<nn::hid::detail::RxPacketHistory> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result AcquireSerialFlashEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result ReadSerialFlash(std::uint32_t address, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result WriteSerialFlash(std::uint32_t address, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, std::uint64_t writeSize, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result GetSerialFlashResult(nn::hid::system::UniquePadId id) NN_NOEXCEPT;
        nn::Result GetAbstractedPadHandles(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::hid::debug::AbstractedPadHandle>& pOutHandles) NN_NOEXCEPT;
        nn::Result GetAbstractedPadState(nn::sf::Out<nn::hid::debug::AbstractedPadState> pOutState, nn::hid::debug::AbstractedPadHandle handle) NN_NOEXCEPT;
        nn::Result GetAbstractedPadsState(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::hid::debug::AbstractedPadHandle>& pOutHandles, const nn::sf::OutArray<nn::hid::debug::AbstractedPadState>& pOutStates) NN_NOEXCEPT;
        nn::Result SetAutoPilotVirtualPadState(nn::hid::debug::AbstractedVirtualPadId virtualPadId, const nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT;
        nn::Result UnsetAutoPilotVirtualPadState(nn::hid::debug::AbstractedVirtualPadId virtualPadId) NN_NOEXCEPT;
        nn::Result UnsetAllAutoPilotVirtualPadState() NN_NOEXCEPT;
        nn::Result AddRegisteredDevice(const nn::hid::system::RegisteredDevice& device) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result DeactivateDebugPad() NN_NOEXCEPT;
    nn::Result SetDebugPadAutoPilotState(const nn::hid::debug::DebugPadAutoPilotState& value) NN_NOEXCEPT;
    nn::Result UnsetDebugPadAutoPilotState() NN_NOEXCEPT;
    nn::Result DeactivateTouchScreen() NN_NOEXCEPT;
    nn::Result SetTouchScreenAutoPilotState(const nn::sf::InArray<nn::hid::TouchState>& touches) NN_NOEXCEPT;
    nn::Result UnsetTouchScreenAutoPilotState() NN_NOEXCEPT;
    nn::Result DeactivateMouse() NN_NOEXCEPT;
    nn::Result SetMouseAutoPilotState(const nn::hid::debug::MouseAutoPilotState& value) NN_NOEXCEPT;
    nn::Result UnsetMouseAutoPilotState() NN_NOEXCEPT;
    nn::Result DeactivateKeyboard() NN_NOEXCEPT;
    nn::Result SetKeyboardAutoPilotState(const nn::hid::debug::KeyboardAutoPilotState& value) NN_NOEXCEPT;
    nn::Result UnsetKeyboardAutoPilotState() NN_NOEXCEPT;
    nn::Result DeactivateXpad(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
    nn::Result SetXpadAutoPilotState(nn::hid::BasicXpadId xpadId, const nn::hid::debug::BasicXpadAutoPilotState& value) NN_NOEXCEPT;
    nn::Result UnsetXpadAutoPilotState(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
    nn::Result DeactivateJoyXpad(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
    nn::Result DeactivateGesture() NN_NOEXCEPT;
    nn::Result DeactivateHomeButton() NN_NOEXCEPT;
    nn::Result SetHomeButtonAutoPilotState(nn::hid::debug::HomeButtonAutoPilotState value) NN_NOEXCEPT;
    nn::Result UnsetHomeButtonAutoPilotState() NN_NOEXCEPT;
    nn::Result DeactivateSleepButton() NN_NOEXCEPT;
    nn::Result SetSleepButtonAutoPilotState(nn::hid::debug::SleepButtonAutoPilotState value) NN_NOEXCEPT;
    nn::Result UnsetSleepButtonAutoPilotState() NN_NOEXCEPT;
    nn::Result DeactivateInputDetector() NN_NOEXCEPT;
    nn::Result DeactivateCaptureButton() NN_NOEXCEPT;
    nn::Result SetCaptureButtonAutoPilotState(nn::hid::debug::CaptureButtonAutoPilotState value) NN_NOEXCEPT;
    nn::Result UnsetCaptureButtonAutoPilotState() NN_NOEXCEPT;
    nn::Result SetShiftAccelerometerCalibrationValue(nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT;
    nn::Result GetShiftAccelerometerCalibrationValue(nn::sf::Out<float> shiftOrigin, nn::sf::Out<float> shiftSensitivity, nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result SetShiftGyroscopeCalibrationValue(nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT;
    nn::Result GetShiftGyroscopeCalibrationValue(nn::sf::Out<float> shiftOrigin, nn::sf::Out<float> shiftSensitivity, nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DeactivateConsoleSixAxisSensor() NN_NOEXCEPT;
    nn::Result GetConsoleSixAxisSensorSamplingFrequency(nn::sf::Out<std::int64_t> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DeactivateSevenSixAxisSensor() NN_NOEXCEPT;
    nn::Result GetConsoleSixAxisSensorCountStates(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::hid::debug::ConsoleSixAxisSensorCountState>& pOutStates, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result ActivateFirmwareUpdate() NN_NOEXCEPT;
    nn::Result DeactivateFirmwareUpdate() NN_NOEXCEPT;
    nn::Result StartFirmwareUpdate(nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result GetFirmwareUpdateStage(nn::sf::Out<std::int64_t> outStage, nn::sf::Out<std::int64_t> outProgress) NN_NOEXCEPT;
    nn::Result GetFirmwareVersion(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::NpadIdType id, nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT;
    nn::Result GetDestinationFirmwareVersion(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::NpadIdType id, nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT;
    nn::Result DiscardFirmwareInfoCacheForRevert() NN_NOEXCEPT;
    nn::Result StartFirmwareUpdateForRevert(nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result GetAvailableFirmwareVersionForRevert(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result IsFirmwareUpdatingDevice(nn::sf::Out<bool> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result StartFirmwareUpdateIndividual(nn::sf::Out<nn::hid::system::FirmwareUpdateDeviceHandle> outHandle, nn::hid::system::UniquePadId id, std::int64_t target, nn::sf::NativeHandle&& imageHandle, std::uint64_t imageSize) NN_NOEXCEPT;
    nn::Result UpdateControllerColor(nn::util::Color4u8Type mainColor, nn::util::Color4u8Type subColor, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result ConnectUsbPadsAsync() NN_NOEXCEPT;
    nn::Result DisconnectUsbPadsAsync() NN_NOEXCEPT;
    nn::Result UpdateDesignInfo(nn::util::Color4u8Type mainColor, nn::util::Color4u8Type subColor, nn::util::Color4u8Type thirdColor, nn::util::Color4u8Type forthColor, std::uint32_t variation, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result GetUniquePadDriverState(nn::sf::Out<nn::hid::detail::PadDriverState> outState, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result GetSixAxisSensorDriverStates(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::hid::detail::SixAxisSensorDriverState>& outStates, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result GetRxPacketHistory(nn::sf::Out<nn::hid::detail::RxPacketHistory> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result AcquireSerialFlashEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result ReadSerialFlash(std::uint32_t address, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result WriteSerialFlash(std::uint32_t address, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, std::uint64_t writeSize, nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result GetSerialFlashResult(nn::hid::system::UniquePadId id) NN_NOEXCEPT;
    nn::Result GetAbstractedPadHandles(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::hid::debug::AbstractedPadHandle>& pOutHandles) NN_NOEXCEPT;
    nn::Result GetAbstractedPadState(nn::sf::Out<nn::hid::debug::AbstractedPadState> pOutState, nn::hid::debug::AbstractedPadHandle handle) NN_NOEXCEPT;
    nn::Result GetAbstractedPadsState(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::hid::debug::AbstractedPadHandle>& pOutHandles, const nn::sf::OutArray<nn::hid::debug::AbstractedPadState>& pOutStates) NN_NOEXCEPT;
    nn::Result SetAutoPilotVirtualPadState(nn::hid::debug::AbstractedVirtualPadId virtualPadId, const nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT;
    nn::Result UnsetAutoPilotVirtualPadState(nn::hid::debug::AbstractedVirtualPadId virtualPadId) NN_NOEXCEPT;
    nn::Result UnsetAllAutoPilotVirtualPadState() NN_NOEXCEPT;
    nn::Result AddRegisteredDevice(const nn::hid::system::RegisteredDevice& device) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::hid::IHidDebugServer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateDebugPad)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateDebugPad);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDebugPadAutoPilotState, (const ::nn::hid::debug::DebugPadAutoPilotState& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDebugPadAutoPilotState, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetDebugPadAutoPilotState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnsetDebugPadAutoPilotState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateTouchScreen)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateTouchScreen);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTouchScreenAutoPilotState, (const ::nn::sf::InArray<::nn::hid::TouchState>& touches))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetTouchScreenAutoPilotState, (touches));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetTouchScreenAutoPilotState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnsetTouchScreenAutoPilotState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateMouse)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateMouse);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMouseAutoPilotState, (const ::nn::hid::debug::MouseAutoPilotState& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMouseAutoPilotState, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetMouseAutoPilotState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnsetMouseAutoPilotState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateKeyboard)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateKeyboard);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetKeyboardAutoPilotState, (const ::nn::hid::debug::KeyboardAutoPilotState& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetKeyboardAutoPilotState, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetKeyboardAutoPilotState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnsetKeyboardAutoPilotState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateXpad, (::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeactivateXpad, (xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetXpadAutoPilotState, (::nn::hid::BasicXpadId xpadId, const ::nn::hid::debug::BasicXpadAutoPilotState& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetXpadAutoPilotState, (xpadId, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnsetXpadAutoPilotState, (::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnsetXpadAutoPilotState, (xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateJoyXpad, (::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeactivateJoyXpad, (xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateGesture)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateGesture);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateHomeButton)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateHomeButton);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHomeButtonAutoPilotState, (::nn::hid::debug::HomeButtonAutoPilotState value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetHomeButtonAutoPilotState, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetHomeButtonAutoPilotState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnsetHomeButtonAutoPilotState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateSleepButton)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateSleepButton);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSleepButtonAutoPilotState, (::nn::hid::debug::SleepButtonAutoPilotState value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSleepButtonAutoPilotState, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetSleepButtonAutoPilotState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnsetSleepButtonAutoPilotState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateInputDetector)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateInputDetector);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateCaptureButton)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateCaptureButton);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCaptureButtonAutoPilotState, (::nn::hid::debug::CaptureButtonAutoPilotState value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetCaptureButtonAutoPilotState, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetCaptureButtonAutoPilotState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnsetCaptureButtonAutoPilotState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetShiftAccelerometerCalibrationValue, (::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetShiftAccelerometerCalibrationValue, (handle, aruid, shiftOrigin, shiftSensitivity));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShiftAccelerometerCalibrationValue, (::nn::sf::Out<float> shiftOrigin, ::nn::sf::Out<float> shiftSensitivity, ::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetShiftAccelerometerCalibrationValue, (shiftOrigin, shiftSensitivity, handle, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetShiftGyroscopeCalibrationValue, (::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetShiftGyroscopeCalibrationValue, (handle, aruid, shiftOrigin, shiftSensitivity));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShiftGyroscopeCalibrationValue, (::nn::sf::Out<float> shiftOrigin, ::nn::sf::Out<float> shiftSensitivity, ::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetShiftGyroscopeCalibrationValue, (shiftOrigin, shiftSensitivity, handle, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateConsoleSixAxisSensor)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateConsoleSixAxisSensor);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConsoleSixAxisSensorSamplingFrequency, (::nn::sf::Out<::std::int64_t> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetConsoleSixAxisSensorSamplingFrequency, (outValue, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateSevenSixAxisSensor)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateSevenSixAxisSensor);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConsoleSixAxisSensorCountStates, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::hid::debug::ConsoleSixAxisSensorCountState>& pOutStates, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetConsoleSixAxisSensorCountStates, (outCount, pOutStates, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ActivateFirmwareUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ActivateFirmwareUpdate);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateFirmwareUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeactivateFirmwareUpdate);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdate, (::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartFirmwareUpdate, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFirmwareUpdateStage, (::nn::sf::Out<::std::int64_t> outStage, ::nn::sf::Out<::std::int64_t> outProgress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFirmwareUpdateStage, (outStage, outProgress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFirmwareVersion, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::NpadIdType id, ::nn::hid::system::NpadDeviceTypeSet deviceType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFirmwareVersion, (outValue, id, deviceType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDestinationFirmwareVersion, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::NpadIdType id, ::nn::hid::system::NpadDeviceTypeSet deviceType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDestinationFirmwareVersion, (outValue, id, deviceType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DiscardFirmwareInfoCacheForRevert)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DiscardFirmwareInfoCacheForRevert);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdateForRevert, (::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartFirmwareUpdateForRevert, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailableFirmwareVersionForRevert, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAvailableFirmwareVersionForRevert, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsFirmwareUpdatingDevice, (::nn::sf::Out<bool> outValue, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsFirmwareUpdatingDevice, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdateIndividual, (::nn::sf::Out<::nn::hid::system::FirmwareUpdateDeviceHandle> outHandle, ::nn::hid::system::UniquePadId id, ::std::int64_t target, ::nn::sf::NativeHandle&& imageHandle, ::std::uint64_t imageSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartFirmwareUpdateIndividual, (outHandle, id, target, ::std::move(imageHandle), imageSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateControllerColor, (::nn::util::Color4u8Type mainColor, ::nn::util::Color4u8Type subColor, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateControllerColor, (mainColor, subColor, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConnectUsbPadsAsync)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ConnectUsbPadsAsync);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisconnectUsbPadsAsync)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisconnectUsbPadsAsync);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateDesignInfo, (::nn::util::Color4u8Type mainColor, ::nn::util::Color4u8Type subColor, ::nn::util::Color4u8Type thirdColor, ::nn::util::Color4u8Type forthColor, ::std::uint32_t variation, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateDesignInfo, (mainColor, subColor, thirdColor, forthColor, variation, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUniquePadDriverState, (::nn::sf::Out<::nn::hid::detail::PadDriverState> outState, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUniquePadDriverState, (outState, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorDriverStates, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::hid::detail::SixAxisSensorDriverState>& outStates, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSixAxisSensorDriverStates, (outCount, outStates, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRxPacketHistory, (::nn::sf::Out<::nn::hid::detail::RxPacketHistory> outValue, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRxPacketHistory, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireSerialFlashEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireSerialFlashEventHandle, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSerialFlash, (::std::uint32_t address, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadSerialFlash, (address, ::std::move(transferMemoryHandle), transferMemorySize, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteSerialFlash, (::std::uint32_t address, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::std::uint64_t writeSize, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteSerialFlash, (address, ::std::move(transferMemoryHandle), transferMemorySize, writeSize, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSerialFlashResult, (::nn::hid::system::UniquePadId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSerialFlashResult, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadHandles, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>& pOutHandles))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAbstractedPadHandles, (pOutCount, pOutHandles));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadState, (::nn::sf::Out<::nn::hid::debug::AbstractedPadState> pOutState, ::nn::hid::debug::AbstractedPadHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAbstractedPadState, (pOutState, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadsState, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>& pOutHandles, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadState>& pOutStates))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAbstractedPadsState, (pOutCount, pOutHandles, pOutStates));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAutoPilotVirtualPadState, (::nn::hid::debug::AbstractedVirtualPadId virtualPadId, const ::nn::hid::debug::AbstractedPadState& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAutoPilotVirtualPadState, (virtualPadId, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnsetAutoPilotVirtualPadState, (::nn::hid::debug::AbstractedVirtualPadId virtualPadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnsetAutoPilotVirtualPadState, (virtualPadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetAllAutoPilotVirtualPadState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnsetAllAutoPilotVirtualPadState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddRegisteredDevice, (const ::nn::hid::system::RegisteredDevice& device))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddRegisteredDevice, (device));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::hid::IHidDebugServer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::hid::IHidDebugServer))

    // nn::Result DeactivateDebugPad() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateDebugPad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateDebugPad)

    // nn::Result SetDebugPadAutoPilotState(const nn::hid::debug::DebugPadAutoPilotState& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDebugPadAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::debug::DebugPadAutoPilotState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDebugPadAutoPilotState)

    // nn::Result UnsetDebugPadAutoPilotState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetDebugPadAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetDebugPadAutoPilotState)

    // nn::Result DeactivateTouchScreen() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateTouchScreen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateTouchScreen)

    // nn::Result SetTouchScreenAutoPilotState(const nn::sf::InArray<nn::hid::TouchState>& touches) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetTouchScreenAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(touches, 0, (const ::nn::sf::InArray<::nn::hid::TouchState>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (touches))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(touches)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetTouchScreenAutoPilotState)

    // nn::Result UnsetTouchScreenAutoPilotState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetTouchScreenAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetTouchScreenAutoPilotState)

    // nn::Result DeactivateMouse() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateMouse)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateMouse)

    // nn::Result SetMouseAutoPilotState(const nn::hid::debug::MouseAutoPilotState& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMouseAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::debug::MouseAutoPilotState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(28)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMouseAutoPilotState)

    // nn::Result UnsetMouseAutoPilotState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetMouseAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetMouseAutoPilotState)

    // nn::Result DeactivateKeyboard() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateKeyboard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateKeyboard)

    // nn::Result SetKeyboardAutoPilotState(const nn::hid::debug::KeyboardAutoPilotState& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetKeyboardAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::debug::KeyboardAutoPilotState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetKeyboardAutoPilotState)

    // nn::Result UnsetKeyboardAutoPilotState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetKeyboardAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetKeyboardAutoPilotState)

    // nn::Result DeactivateXpad(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateXpad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::BasicXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateXpad)

    // nn::Result SetXpadAutoPilotState(nn::hid::BasicXpadId xpadId, const nn::hid::debug::BasicXpadAutoPilotState& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetXpadAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::BasicXpadId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::debug::BasicXpadAutoPilotState), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (xpadId, value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetXpadAutoPilotState)

    // nn::Result UnsetXpadAutoPilotState(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetXpadAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(52)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::BasicXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetXpadAutoPilotState)

    // nn::Result DeactivateJoyXpad(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateJoyXpad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::JoyXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateJoyXpad)

    // nn::Result DeactivateGesture() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateGesture)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(91)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateGesture)

    // nn::Result DeactivateHomeButton() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateHomeButton)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateHomeButton)

    // nn::Result SetHomeButtonAutoPilotState(nn::hid::debug::HomeButtonAutoPilotState value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetHomeButtonAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(111)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::debug::HomeButtonAutoPilotState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetHomeButtonAutoPilotState)

    // nn::Result UnsetHomeButtonAutoPilotState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetHomeButtonAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(112)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetHomeButtonAutoPilotState)

    // nn::Result DeactivateSleepButton() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateSleepButton)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateSleepButton)

    // nn::Result SetSleepButtonAutoPilotState(nn::hid::debug::SleepButtonAutoPilotState value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSleepButtonAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(121)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::debug::SleepButtonAutoPilotState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSleepButtonAutoPilotState)

    // nn::Result UnsetSleepButtonAutoPilotState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetSleepButtonAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(122)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetSleepButtonAutoPilotState)

    // nn::Result DeactivateInputDetector() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateInputDetector)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(123)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateInputDetector)

    // nn::Result DeactivateCaptureButton() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateCaptureButton)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(130)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateCaptureButton)

    // nn::Result SetCaptureButtonAutoPilotState(nn::hid::debug::CaptureButtonAutoPilotState value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetCaptureButtonAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(131)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::debug::CaptureButtonAutoPilotState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetCaptureButtonAutoPilotState)

    // nn::Result UnsetCaptureButtonAutoPilotState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetCaptureButtonAutoPilotState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(132)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetCaptureButtonAutoPilotState)

    // nn::Result SetShiftAccelerometerCalibrationValue(nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetShiftAccelerometerCalibrationValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(133)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(shiftOrigin, (float), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(shiftSensitivity, (float), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (handle, shiftOrigin, shiftSensitivity, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(shiftOrigin), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(shiftSensitivity)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetShiftAccelerometerCalibrationValue)

    // nn::Result GetShiftAccelerometerCalibrationValue(nn::sf::Out<float> shiftOrigin, nn::sf::Out<float> shiftSensitivity, nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetShiftAccelerometerCalibrationValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(134)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(shiftOrigin, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(shiftSensitivity, (float), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (shiftOrigin, shiftSensitivity))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(shiftOrigin), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(shiftSensitivity), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetShiftAccelerometerCalibrationValue)

    // nn::Result SetShiftGyroscopeCalibrationValue(nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetShiftGyroscopeCalibrationValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(135)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(shiftOrigin, (float), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(shiftSensitivity, (float), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (handle, shiftOrigin, shiftSensitivity, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(shiftOrigin), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(shiftSensitivity)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetShiftGyroscopeCalibrationValue)

    // nn::Result GetShiftGyroscopeCalibrationValue(nn::sf::Out<float> shiftOrigin, nn::sf::Out<float> shiftSensitivity, nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetShiftGyroscopeCalibrationValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(136)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(shiftOrigin, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(shiftSensitivity, (float), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (shiftOrigin, shiftSensitivity))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(shiftOrigin), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(shiftSensitivity), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetShiftGyroscopeCalibrationValue)

    // nn::Result DeactivateConsoleSixAxisSensor() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateConsoleSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(140)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateConsoleSixAxisSensor)

    // nn::Result GetConsoleSixAxisSensorSamplingFrequency(nn::sf::Out<std::int64_t> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetConsoleSixAxisSensorSamplingFrequency)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(141)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetConsoleSixAxisSensorSamplingFrequency)

    // nn::Result DeactivateSevenSixAxisSensor() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateSevenSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(142)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateSevenSixAxisSensor)

    // nn::Result GetConsoleSixAxisSensorCountStates(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::hid::debug::ConsoleSixAxisSensorCountState>& pOutStates, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetConsoleSixAxisSensorCountStates)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(143)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutStates, 0, (const ::nn::sf::OutArray<::nn::hid::debug::ConsoleSixAxisSensorCountState>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutStates))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutStates), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetConsoleSixAxisSensorCountStates)

    // nn::Result ActivateFirmwareUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateFirmwareUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateFirmwareUpdate)

    // nn::Result DeactivateFirmwareUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateFirmwareUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateFirmwareUpdate)

    // nn::Result StartFirmwareUpdate(nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartFirmwareUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartFirmwareUpdate)

    // nn::Result GetFirmwareUpdateStage(nn::sf::Out<std::int64_t> outStage, nn::sf::Out<std::int64_t> outProgress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFirmwareUpdateStage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStage, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outProgress, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outStage, outProgress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProgress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFirmwareUpdateStage)

    // nn::Result GetFirmwareVersion(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::NpadIdType id, nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFirmwareVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceType, (::nn::hid::system::NpadDeviceTypeSet), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, deviceType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::hid::debug::FirmwareVersion), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFirmwareVersion)

    // nn::Result GetDestinationFirmwareVersion(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::NpadIdType id, nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDestinationFirmwareVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceType, (::nn::hid::system::NpadDeviceTypeSet), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, deviceType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::hid::debug::FirmwareVersion), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDestinationFirmwareVersion)

    // nn::Result DiscardFirmwareInfoCacheForRevert() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DiscardFirmwareInfoCacheForRevert)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DiscardFirmwareInfoCacheForRevert)

    // nn::Result StartFirmwareUpdateForRevert(nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartFirmwareUpdateForRevert)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(208)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartFirmwareUpdateForRevert)

    // nn::Result GetAvailableFirmwareVersionForRevert(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAvailableFirmwareVersionForRevert)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(209)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::hid::debug::FirmwareVersion), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAvailableFirmwareVersionForRevert)

    // nn::Result IsFirmwareUpdatingDevice(nn::sf::Out<bool> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsFirmwareUpdatingDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsFirmwareUpdatingDevice)

    // nn::Result StartFirmwareUpdateIndividual(nn::sf::Out<nn::hid::system::FirmwareUpdateDeviceHandle> outHandle, nn::hid::system::UniquePadId id, std::int64_t target, nn::sf::NativeHandle&& imageHandle, std::uint64_t imageSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartFirmwareUpdateIndividual)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(211)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(imageHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (imageHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::int64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (id, target, imageSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::hid::system::FirmwareUpdateDeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartFirmwareUpdateIndividual)

    // nn::Result UpdateControllerColor(nn::util::Color4u8Type mainColor, nn::util::Color4u8Type subColor, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateControllerColor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(221)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mainColor, (::nn::util::Color4u8Type), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(subColor, (::nn::util::Color4u8Type), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (mainColor, subColor, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mainColor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(subColor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateControllerColor)

    // nn::Result ConnectUsbPadsAsync() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConnectUsbPadsAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(222)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConnectUsbPadsAsync)

    // nn::Result DisconnectUsbPadsAsync() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisconnectUsbPadsAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(223)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisconnectUsbPadsAsync)

    // nn::Result UpdateDesignInfo(nn::util::Color4u8Type mainColor, nn::util::Color4u8Type subColor, nn::util::Color4u8Type thirdColor, nn::util::Color4u8Type forthColor, std::uint32_t variation, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateDesignInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(224)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mainColor, (::nn::util::Color4u8Type), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(subColor, (::nn::util::Color4u8Type), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(thirdColor, (::nn::util::Color4u8Type), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(forthColor, (::nn::util::Color4u8Type), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(variation, (::std::uint32_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (mainColor, subColor, thirdColor, forthColor, variation, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mainColor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(subColor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(thirdColor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(forthColor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(variation), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateDesignInfo)

    // nn::Result GetUniquePadDriverState(nn::sf::Out<nn::hid::detail::PadDriverState> outState, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUniquePadDriverState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(225)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outState, (::nn::hid::detail::PadDriverState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUniquePadDriverState)

    // nn::Result GetSixAxisSensorDriverStates(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::hid::detail::SixAxisSensorDriverState>& outStates, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSixAxisSensorDriverStates)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(226)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outStates, 0, (const ::nn::sf::OutArray<::nn::hid::detail::SixAxisSensorDriverState>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outStates))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStates), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSixAxisSensorDriverStates)

    // nn::Result GetRxPacketHistory(nn::sf::Out<nn::hid::detail::RxPacketHistory> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRxPacketHistory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(227)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::hid::detail::RxPacketHistory), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRxPacketHistory)

    // nn::Result AcquireSerialFlashEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireSerialFlashEventHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(228)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireSerialFlashEventHandle)

    // nn::Result ReadSerialFlash(std::uint32_t address, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadSerialFlash)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(229)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transferMemorySize, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (address, transferMemorySize, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemorySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadSerialFlash)

    // nn::Result WriteSerialFlash(std::uint32_t address, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, std::uint64_t writeSize, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteSerialFlash)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(230)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transferMemorySize, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(writeSize, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (address, transferMemorySize, writeSize, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemorySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(writeSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteSerialFlash)

    // nn::Result GetSerialFlashResult(nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSerialFlashResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(231)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::system::UniquePadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSerialFlashResult)

    // nn::Result GetAbstractedPadHandles(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::hid::debug::AbstractedPadHandle>& pOutHandles) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAbstractedPadHandles)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutHandles, 0, (const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutHandles))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandles)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAbstractedPadHandles)

    // nn::Result GetAbstractedPadState(nn::sf::Out<nn::hid::debug::AbstractedPadState> pOutState, nn::hid::debug::AbstractedPadHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAbstractedPadState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::debug::AbstractedPadHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutState, (::nn::hid::debug::AbstractedPadState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(152)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAbstractedPadState)

    // nn::Result GetAbstractedPadsState(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::hid::debug::AbstractedPadHandle>& pOutHandles, const nn::sf::OutArray<nn::hid::debug::AbstractedPadState>& pOutStates) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAbstractedPadsState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(303)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutHandles, 0, (const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutStates, 1, (const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadState>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutHandles, pOutStates))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHandles), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutStates)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAbstractedPadsState)

    // nn::Result SetAutoPilotVirtualPadState(nn::hid::debug::AbstractedVirtualPadId virtualPadId, const nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAutoPilotVirtualPadState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(321)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(virtualPadId, (::nn::hid::debug::AbstractedVirtualPadId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::debug::AbstractedPadState), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (virtualPadId, value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(160)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(virtualPadId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAutoPilotVirtualPadState)

    // nn::Result UnsetAutoPilotVirtualPadState(nn::hid::debug::AbstractedVirtualPadId virtualPadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetAutoPilotVirtualPadState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(322)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(virtualPadId, (::nn::hid::debug::AbstractedVirtualPadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (virtualPadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(virtualPadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetAutoPilotVirtualPadState)

    // nn::Result UnsetAllAutoPilotVirtualPadState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnsetAllAutoPilotVirtualPadState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(323)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnsetAllAutoPilotVirtualPadState)

    // nn::Result AddRegisteredDevice(const nn::hid::system::RegisteredDevice& device) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddRegisteredDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(350)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(device, (::nn::hid::system::RegisteredDevice), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (device))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(104)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(device)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddRegisteredDevice)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::DebugPadAutoPilotState), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::TouchState), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::MouseAutoPilotState), 28, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::KeyboardAutoPilotState), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::BasicXpadId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::BasicXpadAutoPilotState), 28, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::JoyXpadId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::HomeButtonAutoPilotState), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::SleepButtonAutoPilotState), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::CaptureButtonAutoPilotState), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::SixAxisSensorHandle), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::ConsoleSixAxisSensorCountState), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::system::UniquePadId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::FirmwareVersion), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::NpadIdType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::system::NpadDeviceTypeSet), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::system::FirmwareUpdateDeviceHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::util::Color4u8Type), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::detail::PadDriverState), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::detail::SixAxisSensorDriverState), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::detail::RxPacketHistory), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::AbstractedPadHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::AbstractedPadState), 152, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::debug::AbstractedVirtualPadId), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::system::RegisteredDevice), 104, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::hid::IHidDebugServer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::hid::IHidDebugServer))

    // nn::Result DeactivateDebugPad() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateDebugPad)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateDebugPad)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateDebugPad)
    }

    // nn::Result SetDebugPadAutoPilotState(const nn::hid::debug::DebugPadAutoPilotState& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDebugPadAutoPilotState, (const ::nn::hid::debug::DebugPadAutoPilotState& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDebugPadAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDebugPadAutoPilotState)
    }

    // nn::Result UnsetDebugPadAutoPilotState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetDebugPadAutoPilotState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetDebugPadAutoPilotState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetDebugPadAutoPilotState)
    }

    // nn::Result DeactivateTouchScreen() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateTouchScreen)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateTouchScreen)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateTouchScreen)
    }

    // nn::Result SetTouchScreenAutoPilotState(const nn::sf::InArray<nn::hid::TouchState>& touches) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTouchScreenAutoPilotState, (const ::nn::sf::InArray<::nn::hid::TouchState>& touches))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetTouchScreenAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(touches)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetTouchScreenAutoPilotState)
    }

    // nn::Result UnsetTouchScreenAutoPilotState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetTouchScreenAutoPilotState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetTouchScreenAutoPilotState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetTouchScreenAutoPilotState)
    }

    // nn::Result DeactivateMouse() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateMouse)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateMouse)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateMouse)
    }

    // nn::Result SetMouseAutoPilotState(const nn::hid::debug::MouseAutoPilotState& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMouseAutoPilotState, (const ::nn::hid::debug::MouseAutoPilotState& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMouseAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMouseAutoPilotState)
    }

    // nn::Result UnsetMouseAutoPilotState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetMouseAutoPilotState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetMouseAutoPilotState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetMouseAutoPilotState)
    }

    // nn::Result DeactivateKeyboard() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateKeyboard)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateKeyboard)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateKeyboard)
    }

    // nn::Result SetKeyboardAutoPilotState(const nn::hid::debug::KeyboardAutoPilotState& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetKeyboardAutoPilotState, (const ::nn::hid::debug::KeyboardAutoPilotState& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetKeyboardAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetKeyboardAutoPilotState)
    }

    // nn::Result UnsetKeyboardAutoPilotState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetKeyboardAutoPilotState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetKeyboardAutoPilotState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetKeyboardAutoPilotState)
    }

    // nn::Result DeactivateXpad(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateXpad, (::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateXpad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateXpad)
    }

    // nn::Result SetXpadAutoPilotState(nn::hid::BasicXpadId xpadId, const nn::hid::debug::BasicXpadAutoPilotState& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetXpadAutoPilotState, (::nn::hid::BasicXpadId xpadId, const ::nn::hid::debug::BasicXpadAutoPilotState& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetXpadAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetXpadAutoPilotState)
    }

    // nn::Result UnsetXpadAutoPilotState(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnsetXpadAutoPilotState, (::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetXpadAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetXpadAutoPilotState)
    }

    // nn::Result DeactivateJoyXpad(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateJoyXpad, (::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateJoyXpad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateJoyXpad)
    }

    // nn::Result DeactivateGesture() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateGesture)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateGesture)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateGesture)
    }

    // nn::Result DeactivateHomeButton() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateHomeButton)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateHomeButton)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateHomeButton)
    }

    // nn::Result SetHomeButtonAutoPilotState(nn::hid::debug::HomeButtonAutoPilotState value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHomeButtonAutoPilotState, (::nn::hid::debug::HomeButtonAutoPilotState value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetHomeButtonAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetHomeButtonAutoPilotState)
    }

    // nn::Result UnsetHomeButtonAutoPilotState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetHomeButtonAutoPilotState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetHomeButtonAutoPilotState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetHomeButtonAutoPilotState)
    }

    // nn::Result DeactivateSleepButton() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateSleepButton)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateSleepButton)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateSleepButton)
    }

    // nn::Result SetSleepButtonAutoPilotState(nn::hid::debug::SleepButtonAutoPilotState value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSleepButtonAutoPilotState, (::nn::hid::debug::SleepButtonAutoPilotState value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSleepButtonAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSleepButtonAutoPilotState)
    }

    // nn::Result UnsetSleepButtonAutoPilotState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetSleepButtonAutoPilotState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetSleepButtonAutoPilotState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetSleepButtonAutoPilotState)
    }

    // nn::Result DeactivateInputDetector() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateInputDetector)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateInputDetector)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateInputDetector)
    }

    // nn::Result DeactivateCaptureButton() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateCaptureButton)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateCaptureButton)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateCaptureButton)
    }

    // nn::Result SetCaptureButtonAutoPilotState(nn::hid::debug::CaptureButtonAutoPilotState value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetCaptureButtonAutoPilotState, (::nn::hid::debug::CaptureButtonAutoPilotState value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetCaptureButtonAutoPilotState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetCaptureButtonAutoPilotState)
    }

    // nn::Result UnsetCaptureButtonAutoPilotState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetCaptureButtonAutoPilotState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetCaptureButtonAutoPilotState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetCaptureButtonAutoPilotState)
    }

    // nn::Result SetShiftAccelerometerCalibrationValue(nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetShiftAccelerometerCalibrationValue, (::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetShiftAccelerometerCalibrationValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(shiftOrigin)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(shiftSensitivity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetShiftAccelerometerCalibrationValue)
    }

    // nn::Result GetShiftAccelerometerCalibrationValue(nn::sf::Out<float> shiftOrigin, nn::sf::Out<float> shiftSensitivity, nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShiftAccelerometerCalibrationValue, (::nn::sf::Out<float> shiftOrigin, ::nn::sf::Out<float> shiftSensitivity, ::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetShiftAccelerometerCalibrationValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(shiftOrigin)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(shiftSensitivity)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetShiftAccelerometerCalibrationValue)
    }

    // nn::Result SetShiftGyroscopeCalibrationValue(nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetShiftGyroscopeCalibrationValue, (::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid, float shiftOrigin, float shiftSensitivity))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetShiftGyroscopeCalibrationValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(shiftOrigin)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(shiftSensitivity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetShiftGyroscopeCalibrationValue)
    }

    // nn::Result GetShiftGyroscopeCalibrationValue(nn::sf::Out<float> shiftOrigin, nn::sf::Out<float> shiftSensitivity, nn::hid::SixAxisSensorHandle handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetShiftGyroscopeCalibrationValue, (::nn::sf::Out<float> shiftOrigin, ::nn::sf::Out<float> shiftSensitivity, ::nn::hid::SixAxisSensorHandle handle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetShiftGyroscopeCalibrationValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(shiftOrigin)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(shiftSensitivity)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetShiftGyroscopeCalibrationValue)
    }

    // nn::Result DeactivateConsoleSixAxisSensor() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateConsoleSixAxisSensor)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateConsoleSixAxisSensor)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateConsoleSixAxisSensor)
    }

    // nn::Result GetConsoleSixAxisSensorSamplingFrequency(nn::sf::Out<std::int64_t> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConsoleSixAxisSensorSamplingFrequency, (::nn::sf::Out<::std::int64_t> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetConsoleSixAxisSensorSamplingFrequency)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetConsoleSixAxisSensorSamplingFrequency)
    }

    // nn::Result DeactivateSevenSixAxisSensor() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateSevenSixAxisSensor)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateSevenSixAxisSensor)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateSevenSixAxisSensor)
    }

    // nn::Result GetConsoleSixAxisSensorCountStates(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::hid::debug::ConsoleSixAxisSensorCountState>& pOutStates, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConsoleSixAxisSensorCountStates, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::hid::debug::ConsoleSixAxisSensorCountState>& pOutStates, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetConsoleSixAxisSensorCountStates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutStates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetConsoleSixAxisSensorCountStates)
    }

    // nn::Result ActivateFirmwareUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ActivateFirmwareUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateFirmwareUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateFirmwareUpdate)
    }

    // nn::Result DeactivateFirmwareUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeactivateFirmwareUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateFirmwareUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateFirmwareUpdate)
    }

    // nn::Result StartFirmwareUpdate(nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdate, (::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartFirmwareUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartFirmwareUpdate)
    }

    // nn::Result GetFirmwareUpdateStage(nn::sf::Out<std::int64_t> outStage, nn::sf::Out<std::int64_t> outProgress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFirmwareUpdateStage, (::nn::sf::Out<::std::int64_t> outStage, ::nn::sf::Out<::std::int64_t> outProgress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFirmwareUpdateStage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProgress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFirmwareUpdateStage)
    }

    // nn::Result GetFirmwareVersion(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::NpadIdType id, nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFirmwareVersion, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::NpadIdType id, ::nn::hid::system::NpadDeviceTypeSet deviceType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFirmwareVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFirmwareVersion)
    }

    // nn::Result GetDestinationFirmwareVersion(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::NpadIdType id, nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDestinationFirmwareVersion, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::NpadIdType id, ::nn::hid::system::NpadDeviceTypeSet deviceType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDestinationFirmwareVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDestinationFirmwareVersion)
    }

    // nn::Result DiscardFirmwareInfoCacheForRevert() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DiscardFirmwareInfoCacheForRevert)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DiscardFirmwareInfoCacheForRevert)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DiscardFirmwareInfoCacheForRevert)
    }

    // nn::Result StartFirmwareUpdateForRevert(nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdateForRevert, (::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartFirmwareUpdateForRevert)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartFirmwareUpdateForRevert)
    }

    // nn::Result GetAvailableFirmwareVersionForRevert(nn::sf::Out<nn::hid::debug::FirmwareVersion> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAvailableFirmwareVersionForRevert, (::nn::sf::Out<::nn::hid::debug::FirmwareVersion> outValue, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAvailableFirmwareVersionForRevert)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAvailableFirmwareVersionForRevert)
    }

    // nn::Result IsFirmwareUpdatingDevice(nn::sf::Out<bool> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsFirmwareUpdatingDevice, (::nn::sf::Out<bool> outValue, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsFirmwareUpdatingDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsFirmwareUpdatingDevice)
    }

    // nn::Result StartFirmwareUpdateIndividual(nn::sf::Out<nn::hid::system::FirmwareUpdateDeviceHandle> outHandle, nn::hid::system::UniquePadId id, std::int64_t target, nn::sf::NativeHandle&& imageHandle, std::uint64_t imageSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartFirmwareUpdateIndividual, (::nn::sf::Out<::nn::hid::system::FirmwareUpdateDeviceHandle> outHandle, ::nn::hid::system::UniquePadId id, ::std::int64_t target, ::nn::sf::NativeHandle&& imageHandle, ::std::uint64_t imageSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartFirmwareUpdateIndividual)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartFirmwareUpdateIndividual)
    }

    // nn::Result UpdateControllerColor(nn::util::Color4u8Type mainColor, nn::util::Color4u8Type subColor, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateControllerColor, (::nn::util::Color4u8Type mainColor, ::nn::util::Color4u8Type subColor, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateControllerColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mainColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(subColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateControllerColor)
    }

    // nn::Result ConnectUsbPadsAsync() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ConnectUsbPadsAsync)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConnectUsbPadsAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConnectUsbPadsAsync)
    }

    // nn::Result DisconnectUsbPadsAsync() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisconnectUsbPadsAsync)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisconnectUsbPadsAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisconnectUsbPadsAsync)
    }

    // nn::Result UpdateDesignInfo(nn::util::Color4u8Type mainColor, nn::util::Color4u8Type subColor, nn::util::Color4u8Type thirdColor, nn::util::Color4u8Type forthColor, std::uint32_t variation, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateDesignInfo, (::nn::util::Color4u8Type mainColor, ::nn::util::Color4u8Type subColor, ::nn::util::Color4u8Type thirdColor, ::nn::util::Color4u8Type forthColor, ::std::uint32_t variation, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateDesignInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mainColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(subColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(thirdColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(forthColor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(variation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateDesignInfo)
    }

    // nn::Result GetUniquePadDriverState(nn::sf::Out<nn::hid::detail::PadDriverState> outState, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUniquePadDriverState, (::nn::sf::Out<::nn::hid::detail::PadDriverState> outState, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUniquePadDriverState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUniquePadDriverState)
    }

    // nn::Result GetSixAxisSensorDriverStates(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::hid::detail::SixAxisSensorDriverState>& outStates, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorDriverStates, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::hid::detail::SixAxisSensorDriverState>& outStates, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSixAxisSensorDriverStates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSixAxisSensorDriverStates)
    }

    // nn::Result GetRxPacketHistory(nn::sf::Out<nn::hid::detail::RxPacketHistory> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRxPacketHistory, (::nn::sf::Out<::nn::hid::detail::RxPacketHistory> outValue, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRxPacketHistory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRxPacketHistory)
    }

    // nn::Result AcquireSerialFlashEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireSerialFlashEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireSerialFlashEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireSerialFlashEventHandle)
    }

    // nn::Result ReadSerialFlash(std::uint32_t address, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSerialFlash, (::std::uint32_t address, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadSerialFlash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemorySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadSerialFlash)
    }

    // nn::Result WriteSerialFlash(std::uint32_t address, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, std::uint64_t writeSize, nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteSerialFlash, (::std::uint32_t address, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::std::uint64_t writeSize, ::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteSerialFlash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemorySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(writeSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteSerialFlash)
    }

    // nn::Result GetSerialFlashResult(nn::hid::system::UniquePadId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSerialFlashResult, (::nn::hid::system::UniquePadId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSerialFlashResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSerialFlashResult)
    }

    // nn::Result GetAbstractedPadHandles(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::hid::debug::AbstractedPadHandle>& pOutHandles) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadHandles, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>& pOutHandles))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAbstractedPadHandles)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandles)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAbstractedPadHandles)
    }

    // nn::Result GetAbstractedPadState(nn::sf::Out<nn::hid::debug::AbstractedPadState> pOutState, nn::hid::debug::AbstractedPadHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadState, (::nn::sf::Out<::nn::hid::debug::AbstractedPadState> pOutState, ::nn::hid::debug::AbstractedPadHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAbstractedPadState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAbstractedPadState)
    }

    // nn::Result GetAbstractedPadsState(nn::sf::Out<std::int32_t> pOutCount, const nn::sf::OutArray<nn::hid::debug::AbstractedPadHandle>& pOutHandles, const nn::sf::OutArray<nn::hid::debug::AbstractedPadState>& pOutStates) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAbstractedPadsState, (::nn::sf::Out<::std::int32_t> pOutCount, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadHandle>& pOutHandles, const ::nn::sf::OutArray<::nn::hid::debug::AbstractedPadState>& pOutStates))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAbstractedPadsState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHandles)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutStates)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAbstractedPadsState)
    }

    // nn::Result SetAutoPilotVirtualPadState(nn::hid::debug::AbstractedVirtualPadId virtualPadId, const nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAutoPilotVirtualPadState, (::nn::hid::debug::AbstractedVirtualPadId virtualPadId, const ::nn::hid::debug::AbstractedPadState& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAutoPilotVirtualPadState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(virtualPadId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAutoPilotVirtualPadState)
    }

    // nn::Result UnsetAutoPilotVirtualPadState(nn::hid::debug::AbstractedVirtualPadId virtualPadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnsetAutoPilotVirtualPadState, (::nn::hid::debug::AbstractedVirtualPadId virtualPadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetAutoPilotVirtualPadState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(virtualPadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetAutoPilotVirtualPadState)
    }

    // nn::Result UnsetAllAutoPilotVirtualPadState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnsetAllAutoPilotVirtualPadState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnsetAllAutoPilotVirtualPadState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnsetAllAutoPilotVirtualPadState)
    }

    // nn::Result AddRegisteredDevice(const nn::hid::system::RegisteredDevice& device) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddRegisteredDevice, (const ::nn::hid::system::RegisteredDevice& device))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddRegisteredDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(device)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddRegisteredDevice)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::hid::IHidDebugServer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::hid::IHidDebugServer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateDebugPad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateDebugPad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDebugPadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDebugPadAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetDebugPadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetDebugPadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateTouchScreen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateTouchScreen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetTouchScreenAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(touches)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetTouchScreenAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(touches)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetTouchScreenAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetTouchScreenAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateMouse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateMouse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMouseAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMouseAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetMouseAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetMouseAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateKeyboard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateKeyboard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetKeyboardAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetKeyboardAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetKeyboardAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetKeyboardAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateXpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateXpad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetXpadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetXpadAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetXpadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetXpadAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateJoyXpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateJoyXpad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateGesture)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateGesture)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateHomeButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateHomeButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetHomeButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetHomeButtonAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetHomeButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetHomeButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateSleepButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateSleepButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSleepButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSleepButtonAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetSleepButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetSleepButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateInputDetector)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateInputDetector)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateCaptureButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateCaptureButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetCaptureButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetCaptureButtonAutoPilotState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetCaptureButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetCaptureButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetShiftAccelerometerCalibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetShiftAccelerometerCalibrationValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(shiftOrigin),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(shiftSensitivity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetShiftAccelerometerCalibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetShiftAccelerometerCalibrationValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(shiftOrigin),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(shiftSensitivity),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetShiftGyroscopeCalibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetShiftGyroscopeCalibrationValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(shiftOrigin),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(shiftSensitivity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetShiftGyroscopeCalibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetShiftGyroscopeCalibrationValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(shiftOrigin),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(shiftSensitivity),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetConsoleSixAxisSensorSamplingFrequency)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetConsoleSixAxisSensorSamplingFrequency)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetConsoleSixAxisSensorCountStates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutStates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetConsoleSixAxisSensorCountStates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutStates),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateFirmwareUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateFirmwareUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateFirmwareUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateFirmwareUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartFirmwareUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartFirmwareUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFirmwareUpdateStage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFirmwareUpdateStage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFirmwareVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFirmwareVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDestinationFirmwareVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDestinationFirmwareVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DiscardFirmwareInfoCacheForRevert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DiscardFirmwareInfoCacheForRevert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartFirmwareUpdateForRevert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartFirmwareUpdateForRevert)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAvailableFirmwareVersionForRevert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAvailableFirmwareVersionForRevert)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsFirmwareUpdatingDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsFirmwareUpdatingDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartFirmwareUpdateIndividual)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(imageHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartFirmwareUpdateIndividual)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(imageHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateControllerColor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateControllerColor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mainColor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(subColor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConnectUsbPadsAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConnectUsbPadsAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisconnectUsbPadsAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisconnectUsbPadsAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateDesignInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateDesignInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mainColor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(subColor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(thirdColor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(forthColor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(variation),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUniquePadDriverState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUniquePadDriverState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSixAxisSensorDriverStates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outStates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSixAxisSensorDriverStates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outStates),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRxPacketHistory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRxPacketHistory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireSerialFlashEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireSerialFlashEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadSerialFlash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadSerialFlash)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transferMemorySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteSerialFlash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteSerialFlash)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transferMemorySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(writeSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSerialFlashResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSerialFlashResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAbstractedPadHandles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutHandles)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAbstractedPadHandles)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutHandles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAbstractedPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAbstractedPadState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAbstractedPadsState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutHandles)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutStates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAbstractedPadsState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutHandles),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutStates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAutoPilotVirtualPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAutoPilotVirtualPadState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(virtualPadId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetAutoPilotVirtualPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetAutoPilotVirtualPadState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(virtualPadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnsetAllAutoPilotVirtualPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnsetAllAutoPilotVirtualPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddRegisteredDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddRegisteredDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(device)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateDebugPad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDebugPadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetDebugPadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateTouchScreen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetTouchScreenAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetTouchScreenAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateMouse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMouseAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetMouseAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateKeyboard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetKeyboardAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetKeyboardAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateXpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetXpadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetXpadAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateJoyXpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateGesture)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateHomeButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetHomeButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetHomeButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateSleepButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSleepButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetSleepButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateInputDetector)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateCaptureButton)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetCaptureButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetCaptureButtonAutoPilotState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetShiftAccelerometerCalibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetShiftAccelerometerCalibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetShiftGyroscopeCalibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetShiftGyroscopeCalibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetConsoleSixAxisSensorSamplingFrequency)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetConsoleSixAxisSensorCountStates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateFirmwareUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateFirmwareUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartFirmwareUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFirmwareUpdateStage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFirmwareVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDestinationFirmwareVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DiscardFirmwareInfoCacheForRevert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartFirmwareUpdateForRevert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAvailableFirmwareVersionForRevert)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsFirmwareUpdatingDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartFirmwareUpdateIndividual)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateControllerColor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConnectUsbPadsAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisconnectUsbPadsAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateDesignInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUniquePadDriverState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSixAxisSensorDriverStates)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRxPacketHistory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireSerialFlashEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadSerialFlash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteSerialFlash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSerialFlashResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAbstractedPadHandles)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAbstractedPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAbstractedPadsState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAutoPilotVirtualPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetAutoPilotVirtualPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnsetAllAutoPilotVirtualPadState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddRegisteredDevice)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::hid::IHidDebugServer))
