﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_VariationBase.h>

namespace nn {
namespace gfx {

enum /* LowLevelApi */
{
    LowLevelApi_Vk = NN_GFX_CONFIG_API_TYPE_VK
};

/**
* @brief VK を表す型定義です。
*/
typedef ApiType< LowLevelApi_Vk > ApiTypeVk;

/**
* @brief VK1 API を表す型定義です。
*/
typedef ApiVariation< ApiTypeVk, ApiVersion< 1 > > ApiVariationVk1;

template<>
struct DefaultVersion< ApiTypeVk >
{
    typedef ApiVersion< NN_GFX_CONFIG_VK_DEFAULT_VERSION > Version;
};

template<>
struct TargetVersion< ApiTypeVk >
{
    typedef ApiVersion< NN_GFX_CONFIG_VK_TARGET_VERSION > Version;
};

}
}
