﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_VariationBase.h>

namespace nn {
namespace gfx {

enum /* LowLevelApi */
{
    LowLevelApi_Gx = NN_GFX_CONFIG_API_TYPE_GX
};

/**
* @brief GX を表す型定義です。
*/
typedef ApiType< LowLevelApi_Gx > ApiTypeGx;

/**
* @brief GX2 API を表す型定義です。
*/
typedef ApiVariation< ApiTypeGx, ApiVersion< 2 > > ApiVariationGx2;

template<>
struct DefaultVersion< ApiTypeGx >
{
    typedef ApiVersion< NN_GFX_CONFIG_GX_DEFAULT_VERSION > Version;
};

template<>
struct TargetVersion< ApiTypeGx >
{
    typedef ApiVersion< NN_GFX_CONFIG_GX_TARGET_VERSION > Version;
};

}
}
