﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief テクスチャーのデータに関する API の宣言（VK1 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/util/util_BitPack.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.vk.h>

#include <nn/gfx/detail/gfx_Common-api.vk.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief テクスチャーを表す構造体です（VK1 特殊版）
*/
template<>
struct TextureImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です
    nn::util::BitPack8 flags; //!< フラグです
    char reserved[2]; //!< 予約領域です
    uint32_t layerCount; //!< レイヤー数です
    uint32_t levelCount; //!< ミップマップレベル数です
    uint32_t width; //!< 幅テクセル数です
    uint32_t height; //!< 高さテクセル数です
    uint32_t depth; //!< 深度テクセル数です
    int32_t samples; //!< サンプル数です
    int32_t gpuAccessFlag; //!< GPUアクセスフラグです
    uint32_t memorySize; //!< メモリーサイズです

    detail::VkHandle hImage; //!< イメージハンドルです
    detail::VkHandle hMemory; //!< メモリーハンドルです
    nn::gfx::ImageFormat format; //!< 画像フォーマットです

    detail::Ptr< void > pMemory; //!< 初期化で渡されたメモリープールのポインターです
    detail::Ptr< void > userPtr; //!< ユーザーポインターです

    detail::Ptr< void > pManager; //!< テクスチャー管理オブジェクトのポインターです
};

/**
* @brief テクスチャービューを表す構造体です（VK1 特殊版）
*/
template<>
struct TextureViewImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です。
    nn::util::BitPack8 flags; //!< フラグです
    char reserved[2]; //!< 予約領域です
    detail::VkEnum format; //!< 画像フォーマットです
    uint32_t baseMipLevel; //!< 参照する最初のミップレベルです
    uint32_t baseArrayLayer; //!< 参照する最初のレイヤーです
    uint32_t layerCount; //!< レイヤー数です
    uint32_t levelCount; //!< ミップマップレベル数です
    uint32_t width; //!< 幅テクセル数です
    uint32_t height; //!< 高さテクセル数です
    uint32_t depth; //!< 深度テクセル数です
    int32_t samples; //!< サンプル数です
    int32_t gpuAccessFlag; //!< GPUアクセスフラグです

    detail::VkHandle hImage; //!< 参照先イメージハンドルです
    detail::VkHandle hImageView; //!< イメージビューハンドルです
    detail::VkHandle hMemory; //!< メモリーハンドルです
    nn::gfx::ImageFormat originalFormat; //!< 参照先Textureのformatです

    detail::Ptr< void > userPtr; //!< ユーザーポインターです

    detail::Ptr< void > pManager; //!< テクスチャー管理オブジェクトのポインターです
};

/**
* @brief カラーターゲットビューを表す構造体です（VK1 特殊版）
*/
template<>
struct ColorTargetViewImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です
    nn::util::BitPack8 flags; //!< フラグです
    char reserved[2]; //!< 予約領域です
    detail::VkEnum format; //!< 画像フォーマットです

    uint32_t layerCount; //!< レイヤー数です
    uint32_t levelCount; //!< ミップマップレベル数です
    uint32_t targetMipLevel; //!< 参照先ミップレベルです
    uint32_t targetBaseArray; //!< 参照先先頭レイヤーです
    uint32_t targetArrayCount; //!< 参照先レイヤー数です
    uint32_t width; //!< 幅テクセル数です
    uint32_t height; //!< 高さテクセル数です
    uint32_t depth; //!< 深度テクセル数です
    int32_t samples; //!< サンプル数です
    uint32_t memorySize; //!< メモリーサイズです
    nn::gfx::ImageFormat originalFormat; //!< 参照先Textureのformatです

    detail::VkHandle hImage; //!< 参照先イメージハンドルです
    detail::VkHandle hImageView; //!< イメージビューハンドルです
    detail::VkHandle hMemory; //!< デバイスメモリーハンドルです

    detail::Ptr< void > userPtr; //!< ユーザーポインターです

    detail::Ptr< void > pManager; //!< テクスチャー管理オブジェクトのポインターです
};

/**
* @brief 深度ステンシルビューを表す構造体です（VK1 特殊版）
*/
template<>
struct DepthStencilViewImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です
    nn::util::BitPack8 flags; //!< フラグです
    char reserved[2]; //!< 予約領域です
    detail::VkEnum format; //!< 画像フォーマットです
    uint32_t layerCount; //!< レイヤー数です
    uint32_t levelCount; //!< ミップマップレベル数です
    uint32_t targetMipLevel; //!< 参照先ミップレベルです
    uint32_t targetBaseArray; //!< 参照先先頭レイヤーです
    uint32_t targetArrayCount; //!< 参照先レイヤー数です
    uint32_t width; //!< 幅テクセル数です
    uint32_t height; //!< 高さテクセル数です
    uint32_t depth; //!< 深度テクセル数です
    int32_t samples; //!< サンプル数です

    detail::VkHandle hImage; //!< 参照先イメージハンドルです
    detail::VkHandle hImageView; //!< イメージビューハンドルです
    char reserved2[4]; //!< 予約領域です

    detail::Ptr< void > userPtr; //!< ユーザーポインターです

    detail::Ptr< void > pManager; //!< テクスチャー管理オブジェクトのポインターです
};

}
}
