﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief シェーダのデータに関する API の宣言（GL4 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.gx.h>
#include <nn/gfx/gfx_ShaderInfoData.h>

#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief シェーダを表す構造体です（GL4 特殊版）
*/
template<>
struct ShaderImplData< ApiVariationGx2 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_SeparationEnable = ShaderInfoData::Flag_SeparationEnable
    };

    Bit8 state; //!< オブジェクトの状態です
    nn::util::BitPack8 flags; //!< フラグです
    NN_PADDING6;

    detail::Ptr< const void > pVertexShader; //!< 頂点シェーダへのポインタです
    detail::Ptr< const void > pGeometryShader; //!< ジオメトリシェーダへのポインタです
    detail::Ptr< const void > pPixelShader; //!< ピクセルシェーダへのポインタです
    detail::Ptr< const void > pComputeShader; //!< 演算シェーダへのポインタです
    detail::Ptr< const detail::DeviceImpl< ApiVariationGx2 > > pDevice; //!< デバイスへのポインタです

    detail::Ptr< void > userPtr; //!< ユーザポインタです
};


}
}
