﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief コマンドバッファーのデータに関する API の宣言（VK1 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/util/util_BitPack.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.vk.h>

#include <nn/gfx/detail/gfx_Common-api.vk.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief コマンドバッファーを表す構造体です（VK1 特殊版）
*/
template<>
struct CommandBufferImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized,
        State_Begun,
        State_Callback
    };

    enum Flag
    {
        Flag_Shared,
        Flag_ConservativeRasterSupported,
        Flag_PipelineQueryStarted,
        Flag_TimestampUsed,
    };

    Bit8 state; //!< オブジェクトの状態です。
    nn::util::BitPack8 flags; //!< フラグです
    Bit8 commandBufferType; //!< コマンドバッファーの種類です
    Bit8 isVulkanDedicatedApiModeEnabled; //!< 特定のVulkan専用APIが有効かどうかを示します
    Bit16 queueCapability; //!< 提出先のキューの機能性です
    char reserved2[2]; //!< 予約領域です
    uint32_t commandMemorySize; //!< コマンドメモリーのサイズです
    uint32_t controlMemorySize; //!< コントロールメモリーのサイズです
    uint32_t drawDispatchCount; //!< 描画またはディスパッチコマンドの回数です
    uint32_t recordedCommandBufferCount;; //!< レコード済みコマンドバッファーの個数です
    detail::Ptr< detail::DeviceImpl< ApiVariationVk1 > > pGfxDevice; //!< デバイスへのポインターです
    detail::VkHandle hQueryPools[ nn::gfx::QueryTarget_End ]; //!< クエリープールハンドルです
    detail::VkHandle hGraphicsPipelineStatisticsQueryPool; //!< グラフィックス統計一括クエリー用のクエリープールのハンドルです
    detail::VkHandle hFastGraphicsPipelineStatisticsQueryPool; //!< 処理負荷抑制時のグラフィックス統計一括クエリー用のクエリープールのハンドルです
    detail::VkHandle hFastTimestampQueryPool; //!< 処理負荷抑制時のタイムスタンプ用クエリープールのハンドルです
    int32_t fastGraphicsPipelineStatisticsQueryCount; //!< 処理負荷抑制時のクエリーコマンドの追加可能コマンド数です
    int32_t fastTimestampQueryCount; //!< 処理負荷抑制時のタイムスタンプコマンドの追加可能コマンド数です
    int32_t graphicsPipelineStatisticsQueryIndex; //!< PipelineStatistics用の現在のQueryIndexです
    int32_t timestampQueryIndex; //!< タイムスタンプ用の現在のQueryIndexです

    static const int VkCommandThreadCount = 2;
    enum CommandBufferUsage
    {
        CommandBufferUsage_Draw,        //!< 描画用
        CommandBufferUsage_Prepare,     //!< 事前処理用
        CommandBufferUsage_Post,        //!< 事後処理用

        CommandBufferUsage_End
    };
    struct VkCommandBufferHandle
    {
        detail::VkHandle hCommandPool[ CommandBufferUsage_End ];    //!< コマンドプールハンドルです
        detail::VkHandle hCommandBuffer[ CommandBufferUsage_End ];  //!< コマンドバッファーハンドルです
    } vkCommandBufferHandles[ VkCommandThreadCount ];

    detail::Ptr< void > pUniformMemory; //!< CPU mapping of hUniformMemory
    detail::VkHandle hUniformMemory; //!< VkDeviceMemory bound to hUniformBuffer
    detail::VkHandle hUniformBuffer; //!< VkBuffer for storing uniforms set by SetUniform()
    uint32_t uniformBufferSize; //!< Size of hUniformBuffer
    char reserved3[4]; //!< 予約領域です

    detail::Ptr< const void > pCommandList; //!< コマンドリストへのポインターです
    detail::Ptr< const void > pHeadCommandMemory; //!< コマンドメモリーの先頭へのポインターです
    detail::Ptr< void > pCommandMemory; //!< コマンドメモリーへのポインターです
    detail::Ptr< const void > pHeadControlMemory; //!< コントロールメモリーの先頭へのポインターです
    detail::Ptr< void > pControlMemory; //!< コントロールメモリーへのポインターです
    detail::Ptr< void () > pOutOfCommandMemoryCallback; //!< コマンドメモリーが不足したときに呼ばれるコールバックへのポインターです
    detail::Ptr< void () > pOutOfControlMemoryCallback; //!< コントロールメモリーが不足したときに呼ばれるコールバックへのポインターです

    detail::Ptr< const detail::RootSignatureImpl< ApiVariationVk1 > > pGfxRootSignature; //!< ルートシグネチャーへのポインターです

    detail::Ptr< void > pGfxVkManager; //!< VkManagerへのポインターです
    detail::Ptr< void > pCommandThread; //!< CommandThreadへのポインターです
    detail::Ptr< void > userPtr; //!< ユーザーデータへのポインターです

    char defaultControlMemory[ 40 ]; //!< デフォルトのコントロールメモリーです
};

}
}
