﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief コマンドバッファーのデータに関する API の宣言（D3D11 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.d3d.h>

#include <nn/gfx/detail/gfx_Common-api.d3d.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief コマンドバッファーを表す構造体です（D3D11 特殊版）
*/
template<>
struct CommandBufferImplData< ApiVariationD3d11 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized,
        State_Begun,
        State_Callback
    };

    Bit8 state; //!< オブジェクトの状態です。
    Bit8 commandBufferType; //!< コマンドバッファーの種類です
    Bit16 queueCapability; //!< 提出先のキューの機能性です
    uint32_t commandMemorySize; //!< コマンドメモリーのサイズです
    uint32_t controlMemorySize; //!< コントロールメモリーのサイズです
    uint32_t patchControlPointCount; //!< パッチの制御点の数です
    uint32_t sampleMask; //!< サンプルマスクです
    char reserved[ 4 ]; //!< 予約領域です。
    detail::Ptr< detail::DeviceImpl< ApiVariationD3d11 > > pGfxDevice; //!< デバイスへのポインターです
    detail::Ptr< const void > pHeadCommandMemory; //!< コマンドメモリーの先頭へのポインターです
    detail::Ptr< const void > pHeadControlMemory; //!< コントロールメモリーの先頭へのポインターです
    detail::Ptr< void () > pOutOfCommandMemoryCallback; //!< コマンドメモリーが不足したときに呼ばれるコールバックへのポインターです
    detail::Ptr< void () > pOutOfControlMemoryCallback; //!< コントロールメモリーが不足したときに呼ばれるコールバックへのポインターです

    detail::Ptr< const detail::RootSignatureImpl< ApiVariationD3d11 > > pGfxRootSignature; //!< ルートシグネチャーへのポインターです

    detail::Ptr< void > userPtr; //!< ユーザデータへのポインターです

    detail::Ptr< void > pDeferredContext; //!< D3D11DeferredContextのハンドルです。
    detail::Ptr< void > pCommandList; //!< FinishCommandList時に生成されるコマンドリストハンドルです

    char defaultControlMemory[ 40 ]; //!< デフォルトのコントロールメモリーです
};

}
}
