﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <nn/npns.h>

namespace nn { namespace ens { namespace detail { namespace util {

/**
 * @brief   NPNS ライブラリの管理モジュール
 *
 * @details
 *  NPNS ライブラリの遅延初期化や、通知イベントの管理を行います。
 */
class NpnsLibrary
{
public:
    /**
     * @brief   NPNS ライブラリを初期化します。
     *
     * @details
     *  本関数は何回呼び出しても問題ありません。
     */
    static void Initialize() NN_NOEXCEPT
    {
        GetInstance();
    }

    /**
     * @brief   インスタンスを取得します。
     *
     * @return  インスタンス
     */
    static NpnsLibrary& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(NpnsLibrary, s_Instance);
        return s_Instance;
    }

public:
    /**
     * @brief   通知の受信イベントを取得します。
     *
     * @return  通知の受信イベント
     *
     * @details
     */
    nn::os::SystemEvent& GetReceiveEvent() NN_NOEXCEPT
    {
        return m_ReceiveEvent;
    }

private:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    NpnsLibrary() NN_NOEXCEPT
    {
#if defined(NN_BUILD_CONFIG_OS_HORIZON)

        // Generic でアプリケーションが NPNS 関連モジュールをリンクしないで済むよう、 Horizon のみ有効にする。
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::npns::Initialize());
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::npns::ListenToMyApplicationId());

        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::npns::GetReceiveEvent(m_ReceiveEvent));

#endif
    }

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~NpnsLibrary() NN_NOEXCEPT
    {
#if defined(NN_BUILD_CONFIG_OS_HORIZON)

        nn::npns::Finalize();

#endif
    }

private:
    //
    nn::os::SystemEvent m_ReceiveEvent;
};

}}}}
