﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <nn/ens/detail/core/ens_HttpConnection.h>

namespace nn { namespace ens { namespace detail { namespace core {

/**
 * @brief   HTTP コネクションを管理するクラス
 *
 * @details
 *  短期間に連続して HTTP リクエストを出す場合、前回のコネクションを再利用するとパフォーマンスが向上する場合があります。
 */
class HttpConnectionProvider
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    HttpConnectionProvider() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~HttpConnectionProvider() NN_NOEXCEPT;

    /**
     * @brief   HTTP コネクションを獲得します。
     *
     * @pre
     *  - HTTP コネクションを獲得していない
     *
     * @details
     */
    void Acquire() NN_NOEXCEPT;

    /**
     * @brief   HTTP コネクションを解放します。
     *
     * @pre
     *  - HTTP コネクションを獲得済み
     *
     * @details
     */
    void Release() NN_NOEXCEPT;

    /**
     * @brief   HTTP コネクションを取得します。
     *
     * @return  HTTP コネクション
     *
     * @details
     */
    HttpConnection& GetConnection() NN_NOEXCEPT;

private:
    //
    HttpConnection m_Connection;
    //
    std::atomic<bool> m_IsAcquired;
};

}}}}
