﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <curl/curl.h>

namespace nn { namespace ens { namespace detail { namespace core {

/**
 * @brief   HTTP コネクションクラス
 *
 * @details
 */
class HttpConnection
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    HttpConnection() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~HttpConnection() NN_NOEXCEPT;

    /**
     * @brief   初期化します。
     *
     * @return  処理結果
     *
     * @pre
     *  - 未初期化状態である
     *
     * @details
     */
    nn::Result Initialize() NN_NOEXCEPT;

    /**
     * @brief   後始末を行います。
     *
     * @details
     *  本関数を呼び出すことで、未初期化状態になります。
     */
    void Cleanup() NN_NOEXCEPT;

    /**
     * @brief   リセットします。
     *
     * @details
     *  リセットすることで、 HTTP コネクションを再利用することができます。@n
     *  前回と同一のホストにリクエストを出した場合、セッションや DNS のキャッシュが利用されパフォーマンスが向上します。
     */
    void Reset() NN_NOEXCEPT;

    /**
     * @brief   通信処理を実行します。
     *
     * @param[in]   pCancelEvent    キャンセルイベント
     *
     * @return  処理結果
     *
     * @pre
     *  - 初期化済みである
     *
     * @details
     *  通信処理を実行する前に、 GetHandle() で取得したハンドルにパラメータを設定してください。
     */
    nn::Result Perform(nn::os::Event* pCancelEvent = nullptr) NN_NOEXCEPT;

    /**
     * @brief   ハンドルを取得します。
     *
     * @return  ハンドル
     *
     * @details
     *  初期化されていない場合、 nullptr が返ります。
     */
    CURL* GetHandle() NN_NOEXCEPT;

private:
    //
    CURLM* m_pMultiHandle;
    //
    CURL* m_pHandle;
};

}}}}
