﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_AuthenticationTask.h>
#include <nn/ens/ens_TypesForAcbaa.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

/**
 * @brief   RegisterMyDesignAuthorProfile の非同期処理実装タスク
 *
 * @details
 */
class TaskRegisterMyDesignAuthorProfile : public detail::core::AuthenticationTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskRegisterMyDesignAuthorProfile() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~TaskRegisterMyDesignAuthorProfile() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[out]  pOutId  マイデザイン作者 ID
     * @param[in]   name    マイデザイン作者名
     *
     * @details
     */
    void SetParameter(MyDesignAuthorId* pOutId, const MyDesignAuthorName& name) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result ExecuteSteps() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    MyDesignAuthorId* m_pOutId;
    //
    MyDesignAuthorName m_Name;

private:
    //
    nn::Result StepRegister() NN_NOEXCEPT;
};

}}}}}
