﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrv_ApplicationAlbumEntry.h"
#include "capsrv_ScreenShotSize.h"
#include "capsrv_ScreenShotAttribute.h"
#include "capsrv_OverlayNotificationRequest.h"
#include "capsrv_SystemReservedInfo.h"

namespace nn{ namespace capsrv{

    //! @brief アプリケーション用のスクリーンショット機能を初期化します。
    //! @pre  アプリケーション用のスクリーンショット機能が未初期化
    //! @post アプリケーション用のスクリーンショット機能が初期化済
    nn::Result InitializeForApplication() NN_NOEXCEPT;

    //! @brief アプリケーション用のスクリーンショット機能を終了します。
    //! @pre  アプリケーション用のスクリーンショット機能が初期化済
    //! @post アプリケーション用のスクリーンショット機能が未初期化
    void FinalizeForApplication() NN_NOEXCEPT;

    //! @brief 指定した画像をアプリケーションの画面写真として保存します。
    //! @pre アプリケーション用のスクリーンショット機能が初期化済
    //! @param[out] pOutEntry     保存した画面写真の識別子を受け取る変数のポインタです。
    //! @param[in] imageData      保存する画像データです。
    //! @param[in] imageDataSize  保存する画像データの大きさ（バイト）です。
    //! @param[in] size           保存する画面写真の大きさです。
    //! @param[in] overlayRequest 保存結果をオーバーレイで通知する条件です。
    //! @details
    //! 指定した画像を呼出元のアプリケーションの画面写真として保存します。
    //! *pOutEntry に保存した画面写真の識別子が代入されます。
    //! この識別子はアプリケーションが終了するまで有効です。アプリケーションが再起動された場合識別子は無効化されます。
    //!
    //! imageData には CPU キャッシュが有効な GPU のメモリプール上のメモリを渡すことができます。
    nn::Result SaveScreenShotForApplication(
        ApplicationAlbumEntry* pOutEntry,
        const void* imageData,
        size_t imageDataSize,
        ScreenShotSizeType size,
        OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT;

    //! @brief 指定した画像をアプリケーションの画面写真として保存します。
    //! @pre アプリケーション用のスクリーンショット機能が初期化済
    //! @param[out] pOutEntry     保存した画面写真の識別子を受け取る変数のポインタです。
    //! @param[in] imageData      保存する画像データです。
    //! @param[in] imageDataSize  保存する画像データの大きさ（バイト）です。
    //! @param[in] attribute      保存する画面写真の属性です。
    //! @param[in] overlayRequest 保存結果をオーバーレイで通知する条件です。
    //! @details
    //! 指定した画像を呼出元のアプリケーションの画面写真として保存します。
    //! *pOutEntry に保存した画面写真の識別子が代入されます。
    //! この識別子はアプリケーションが終了するまで有効です。アプリケーションが再起動された場合識別子は無効化されます。
    //!
    //! imageData には CPU キャッシュが有効な GPU のメモリプール上のメモリを渡すことができます。
    nn::Result SaveScreenShotForApplication(
        ApplicationAlbumEntry* pOutEntry,
        const void* imageData,
        size_t imageDataSize,
        const nn::capsrv::ScreenShotAttribute& attribute,
        OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT;

    //! @brief 指定した画像をアプリケーションの画面写真として保存します（ユーザ識別子情報付き）。
    //! @pre アプリケーション用のスクリーンショット機能が初期化済
    //! @param[out] pOutEntry     保存した画面写真の識別子を受け取る変数のポインタです。
    //! @param[in] imageData      保存する画像データです。
    //! @param[in] imageDataSize  保存する画像データの大きさ（バイト）です。
    //! @param[in] attribute      保存する画面写真の属性です。
    //! @param[in] userIdList     ユーザ識別子情報
    //! @param[in] overlayRequest 保存結果をオーバーレイで通知する条件です。
    //! @details
    //! 指定した画像を呼出元のアプリケーションの画面写真として保存します。
    //! *pOutEntry に保存した画面写真の識別子が代入されます。
    //! この識別子はアプリケーションが終了するまで有効です。アプリケーションが再起動された場合識別子は無効化されます。
    //!
    //! imageData には CPU キャッシュが有効な GPU のメモリプール上のメモリを渡すことができます。
    nn::Result SaveScreenShotForApplication(
        ApplicationAlbumEntry* pOutEntry,
        const void* imageData,
        size_t imageDataSize,
        const nn::capsrv::ScreenShotAttribute& attribute,
        const nn::capsrv::UserIdList& userIdList,
        OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT;

}}

