﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace capsrv{

    //! @brief 画面写真の作成結果をオーバーレイ通知として表示するかを指定します。
    //! @details
    //! 値はビット和で合成することができます。
    enum OverlayNotificationRequest
    {
        //! @brief オーバーレイ通知を行いません。
        OverlayNotificationRequest_None = 0,

        //! @brief 成功時にオーバーレイ通知を行います。
        OverlayNotificationRequest_OnSuccess = (1 << 0),

        //! @brief 失敗時にオーバーレイ通知を行います。
        OverlayNotificationRequest_OnFailure = (1 << 1),

        //! @brief 成功失敗ともにオーバーレイ通知を行います。
        OverlayNotificationRequest_All = OverlayNotificationRequest_OnSuccess | OverlayNotificationRequest_OnFailure,
    };

    typedef uint32_t OverlayNotificationRequestType;

}}
