﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>
#include <nn/album/album_MovieMaker.h>

namespace nn{ namespace capsrv{

    //! @brief アプリケーションの指定するデータです。
    //! @details
    //! アプリケーションが自由に設定することができる値です。
    //! この値はアルバムのファイル内に書き込まれ、ファイルの読込時に
    //! size 情報と共にアプリケーションが受け取ることができます。
    //!
    struct ApplicationData
    {
        char value[1024];
        uint32_t size;
    };

    NN_STATIC_ASSERT(album::AlbumUserDataSizeMax <= sizeof(ApplicationData::value));

}}
