﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/capsrv/capsrv_ApplicationAlbumEntry.h>
#include <nn/capsrv/capsrv_AlbumFileDateTime.h>
#include <nn/album/album_AlbumFileEntry.private.h>

namespace nn { namespace capsrv {

    //! @brief アルバム内のファイルを一意に表すアプリケーション向けの識別子です
    //! @detail
    //! album::AlbumFileEntry の内部実装です。
    struct NN_ALIGNAS(8) ApplicationAlbumFileEntry
    {
        ApplicationAlbumEntry   _encrypted;     // 暗号化された AlbumEntry
        AlbumFileDateTime       dateTime;       // ファイル作成日時
        char                    reserved[8];
    };

    NN_STATIC_ASSERT(NN_ALIGNOF(capsrv::ApplicationAlbumFileEntry) == NN_ALIGNOF(album::AlbumFileEntry));
    NN_STATIC_ASSERT(sizeof(capsrv::ApplicationAlbumFileEntry) == sizeof(album::AlbumFileEntry));

}}  // namespace nn::capsrv
