﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/album/album_SaveScreenshot.h>
#include <nn/album/album_SaveAndShareScreenshot.h>

namespace nn{ namespace album{

    // 引数の順番は以下のとおり。不要なものはスキップ。
    //
    //   +--------------------------------------+------+------+---------------------------------
    //   | 引数                                 | 種別 | 指定 | 備考
    //   +--------------------------------------+------+------+---------------------------------
    //   | ShareId*                 pOutShareId | 投稿 | 任意 | 非公開 API のみ
    //   | const void*               pImageData | 保存 | 必須 |
    //   | size_t                 imageDataSize | 保存 | 必須 |
    //   | ImageSize             screenshotSize | 保存 | 必須 |
    //   | ImageOrientation    imageOrientation | 保存 | 任意 | 既定値は ImageOrientaiton_None
    //   | AlbumReportOption       reportOption | 保存 | (※) | 既定値は AlbumReportOption_ReportAlways
    //   | const nn::account::Uid&          uid | 投稿 | (※) | 既定値は nn::account::InvalidUid
    //   | const char*     presetPostingMessage | 投稿 | 任意 | 既定値は空文字列
    //   +--------------------------------------+------+------+---------------------------------
    //
    // ※… 省略しても構わないが、明示的に指定する API しか用意していない。
}}
