﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/*!
    @file
    @brief   アルバムアプレットで使用される型や定数の宣言(非公開)
*/

#include <nn/nn_Common.h>

namespace nn { namespace album {

NN_PRAGMA_PUSH_WARNINGS
NN_ENABLE_WARNING_IMPLICIT_PADDING_WITHIN_CLASS

/*!
    @brief アルバムアプレットの起動モードを示す列挙子
*/
enum AppletMode : uint8_t
{
    AppletMode_ShowAppFiles,                        //!< 対象となるアプリに紐づいたアルバムのファイルを一覧表示する。
    AppletMode_ShowAllFiles,                        //!< アルバム内の全てのファイルを一覧表示する。
    AppletMode_ShowAllFilesForHomeMenu,             //!< アルバム内の全てのファイルを一覧表示する（HOME メニュー専用）。
};

/*!
    @brief アルバムアプレットの起動引数
*/
struct AppletArg
{
    AppletMode mode;                                //!< 起動モード。
};

NN_PRAGMA_POP_WARNINGS

}} // namespace nn::album
