﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;

namespace MakeNsData
{
    public class MakeNsDataArgument
    {
        // 以降にサブコマンドを宣言
        [CommandLineSubCommand("blacklist", Description = "Make blacklist data.")]
        public Commands.BlackListCommand BlackListCommand { get; set; }

        // 対象コマンドを取得
        public Commands.CommandBase GetActiveCommand()
        {
            foreach (var property in GetType().GetProperties())
            {
                var command = property.GetValue(this) as Commands.CommandBase;
                if (command != null)
                {
                    return command;
                }
            }
            return null;
        }
    }

    public class Program
    {
        public static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            if (args == null || args.Length == 0)
            {
                args = new string[] { "help" };
            }
            var parsed = new MakeNsDataArgument();
            if (CommandLineParser.Default.ParseArgs<MakeNsDataArgument>(args, out parsed))
            {
                var command = parsed.GetActiveCommand();
                if (command != null)
                {
                    command.Run();
                }
                else
                {
                    throw new Exception("Not found subcommand.");
                }
            }
            else
            {
                return;
            }
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("[ERROR] {0}", exception.Message);
                Console.Error.Write("StackTrace: {0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }
    }
}
