﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ReadInitialImage.Commands
{
    public class ReadImagePartitionCommand : CommandCommon
    {
        public override void Run()
        {
            RunCommand(reader =>
            {
                var info = reader.InitialImageInfo;
                Console.WriteLine(string.Format("Signature: {0}", info.Signature));
                Console.WriteLine(string.Format("Version: {0}", info.Version));
                Console.WriteLine(string.Format("NumPartitions: {0}", info.NumPartions));
                Console.WriteLine(string.Format("Partitions:"));
                for (int i = 0; i < info.NumPartions; i++)
                {
                    var partition = info.Partitions[i];
                    Console.WriteLine(string.Format("  - Name:    {0}", partition.Name));
                    Console.WriteLine(string.Format("    Address: {0}", partition.Address));
                    Console.WriteLine(string.Format("    Size:    {0}", partition.Size));
                }
            });
        }
    }
}
