﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using CommandUtility;

namespace MakeSignedBinary
{
    public class MakeSignedBinaryArguments
    {
        [CommandLineSubCommand("sign", Description = "sign file.")]
        public Commands.SignCommand SignCommand { get; set; }

        [CommandLineSubCommand("remove-sign", Description = "remove sign.")]
        public Commands.RemoveSignCommand RemoveSignCommand { get; set; }

        [CommandLineSubCommand("change", Description = "change key.")]
        public Commands.ChangeKeyCommand ChangeKeyCommand { get; set; }

        [CommandLineSubCommand("info", Description = "get info.")]
        public Commands.InfoCommand InfoCommand { get; set; }

        [CommandLineSubCommand("verify", Description = "verify signed binary.")]
        public Commands.VerifyCommand VerifyCommand { get; set; }

        [CommandLineSubCommand("generate-config", Description = "generate key config.")]
        public Commands.GenerateConfig GenerateConfig { get; set; }
    }

    public class Program
    {
        public static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            System.Environment.Exit(
                MultiCommandRunner<MakeSignedBinaryArguments>.Run(args));
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("エラー: {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }
    }
}
