﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CommandUtility;
using Nintendo.Foundation.IO;
using System.IO;
using YamlDotNet;
using System.Security.Cryptography;
using System.Text.RegularExpressions;

namespace MakeSignedBinary.Commands
{
    public class SignCommand : SubCommandCommon
    {
        [CommandLineOption('i', "input", Description = "input file")]
        public string InputFile { get; set; }

        [CommandLineOption('a', "append", Description = "append file", DefaultValue = new string[] { })]
        public string[] AppendFiles { get; set; }

        [CommandLineOption('o', "output", Description = "output file", IsRequired = true)]
        public string OutputFile { get; set; }

        [CommandLineOption('k', "key", Description = "input key file", IsRequired = true)]
        public string KeyConfigFile { get; set; }

        [CommandLineOption("disable-encryption", Description = "disable encryption", IsRequired = false)]
        public bool DisableEncryption { get; set; }

        public override int Run()
        {
            var keyConfig = KeyConfig.Load(KeyConfigFile);

            using (var tempHolder = new TemporaryFileHolder("MakeSignedBinary"))
            {
                Utility.SignBinary(OutputFile, InputFile, AppendFiles, keyConfig, tempHolder, DisableEncryption);
            }

            return 0;
        }
    }
}
