﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.InteropServices;

namespace MakeInitialImage
{
    public delegate void PartitionWriterDelegate(Stream outputStream);

    public class InitialImageWriter
    {
        public InitialImageWriter(Stream outputStream)
        {
            this.outputStream = outputStream;
            initialImageInfo = InitialImageInfo.MakeNew();
            WriteHeader();
        }

        public void AddPartition(string name, PartitionWriterDelegate writer)
        {
            AddPartition(new InitialImagePartitionWriter(name, writer));
        }

        public void AddPartition(InitialImagePartitionWriter writer)
        {
            writers.Add(writer);

            partitionDictionary[writer.Info.Name] = partitionIndex;
            partitionIndex += 1;
        }

        public int GetPartitionIndex(string name)
        {
            if (!partitionDictionary.ContainsKey(name))
            {
                throw new Exception(string.Format("Found no initial image partition: {0}", name));
            }

            return partitionDictionary[name];
        }

        public void WritePartitions()
        {
            foreach (var writer in writers)
            {
                var partitionInfo = new InitialImagePartitionInfo()
                {
                    Name = writer.Info.Name,
                    Address = outputStream.Position,
                    Size = 0
                };

                writer.Writer(outputStream);

                partitionInfo.Size = outputStream.Position - partitionInfo.Address;
                initialImageInfo.Partitions[initialImageInfo.NumPartions] = partitionInfo;
                initialImageInfo.NumPartions += 1;
            }

            WriteHeader();
        }

        private void WriteHeader()
        {
            outputStream.Seek(0, SeekOrigin.Begin);
            Utility.WriteBinary<InitialImageInfo>(outputStream, initialImageInfo);
        }

        private InitialImageInfo initialImageInfo = new InitialImageInfo();
        private List<InitialImagePartitionWriter> writers = new List<InitialImagePartitionWriter>();

        private int partitionIndex = 0;
        private Dictionary<string, int> partitionDictionary = new Dictionary<string, int>();

        private Stream outputStream;
    }
}
